/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.handler.PipetteFluidInteractionPointHandler;
import com.adonis.fluid.packet.ClientPacketHandler;
import com.adonis.fluid.packet.PipetteInteractionPointSyncPacket;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PipetteFluidPlacementPacket(ListTag pointsTag, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PipetteFluidPlacementPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fluid", (String)"pipette_placement"));
    public static final StreamCodec<ByteBuf, PipetteFluidPlacementPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG.map(tag -> tag.getList("Points", 10), points -> {
        CompoundTag tag = new CompoundTag();
        tag.put("Points", (Tag)points);
        return tag;
    }), PipetteFluidPlacementPacket::pointsTag, (StreamCodec)BlockPos.STREAM_CODEC, PipetteFluidPlacementPacket::pos, PipetteFluidPlacementPacket::new);

    public PipetteFluidPlacementPacket(Collection<FluidInteractionPoint> points, BlockPos pos) {
        this(PipetteFluidPlacementPacket.createPointsTag(points, pos), pos);
    }

    private static ListTag createPointsTag(Collection<FluidInteractionPoint> points, BlockPos pos) {
        ListTag tag = new ListTag();
        points.stream().map(point -> point.serialize(pos)).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            Level world = player.level();
            if (!world.isLoaded(this.pos)) {
                return;
            }
            BlockEntity be = world.getBlockEntity(this.pos);
            if (be instanceof PipetteBlockEntity) {
                PipetteBlockEntity pipette = (PipetteBlockEntity)be;
                pipette.inputs.clear();
                pipette.outputs.clear();
                pipette.setInteractionPointTag(this.pointsTag);
                pipette.setUpdateInteractionPoints(true);
                pipette.resetMovementState();
                pipette.forceInitInteractionPoints();
                pipette.setChanged();
                pipette.sendData();
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    PipetteInteractionPointSyncPacket syncPacket = new PipetteInteractionPointSyncPacket(this.pos, this.pointsTag);
                    try {
                        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.pos), (CustomPacketPayload)syncPacket, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public record ClientBoundRequest(BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ClientBoundRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fluid", (String)"pipette_request"));
        public static final StreamCodec<ByteBuf, ClientBoundRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientBoundRequest::pos, ClientBoundRequest::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public void handle(IPayloadContext context) {
            context.enqueueWork(() -> {
                if (context.flow().isClientbound() && FMLEnvironment.dist == Dist.CLIENT) {
                    ClientPacketHandler.handlePipetteRequest(this.pos);
                }
            });
        }

        private void handleClient() {
            PipetteFluidInteractionPointHandler.flushSettings(this.pos);
        }
    }
}

