/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.packet;

import com.adonis.fluid.packet.ClientPacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ArmInteractionPointSyncPacket(BlockPos pos, ListTag pointsTag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ArmInteractionPointSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fluid", (String)"arm_sync"));
    public static final StreamCodec<ByteBuf, ArmInteractionPointSyncPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ArmInteractionPointSyncPacket::pos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG.map(tag -> tag.getList("Points", 10), points -> {
        CompoundTag tag = new CompoundTag();
        tag.put("Points", (Tag)points);
        return tag;
    }), ArmInteractionPointSyncPacket::pointsTag, ArmInteractionPointSyncPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound() && FMLEnvironment.dist == Dist.CLIENT) {
                ClientPacketHandler.handleArmSync(this.pos, this.pointsTag);
            }
        });
    }
}

