/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.handler;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.packet.PipetteFluidPlacementPacket;
import com.adonis.fluid.registry.CFBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(value={Dist.CLIENT}, modid="fluid")
public class PipetteFluidInteractionPointHandler {
    static List<FluidInteractionPoint> currentSelection = new ArrayList<FluidInteractionPoint>();
    static ItemStack currentItem;
    static long lastBlockPos;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        PipetteFluidInteractionPointHandler.tick();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void rightClickingBlocksSelectsThem(PlayerInteractEvent.RightClickBlock event) {
        if (!CFBlocks.PIPETTE.isIn(event.getItemStack())) {
            return;
        }
        if (currentItem == null || !ItemStack.matches((ItemStack)currentItem, (ItemStack)event.getItemStack())) {
            currentItem = event.getItemStack();
        }
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        if (world.isClientSide) {
            Player player = event.getEntity();
            if (player != null && !player.isSpectator()) {
                BlockState state = world.getBlockState(pos);
                FluidInteractionPoint point = FluidInteractionPoint.create(world, pos, state);
                if (point == null) {
                    return;
                }
                FluidInteractionPoint selected = PipetteFluidInteractionPointHandler.getSelected(pos);
                if (selected == null) {
                    selected = point;
                    PipetteFluidInteractionPointHandler.put(point);
                }
                selected.cycleMode();
                FluidInteractionPoint.Mode mode = selected.getMode();
                CreateLang.builder().translate(mode.getTranslationKey(), new Object[]{CreateLang.blockName((BlockState)state).style(ChatFormatting.WHITE)}).color(mode.getColor()).sendStatus(player);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        } else {
            BlockState state = world.getBlockState(pos);
            if (FluidInteractionPoint.create(world, pos, state) != null) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void leftClickingBlocksDeselectsThem(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        if (currentItem != null && CFBlocks.PIPETTE.isIn(currentItem) && event.getLevel().isClientSide && PipetteFluidInteractionPointHandler.remove(pos = event.getPos()) != null) {
            event.setCanceled(true);
        }
    }

    public static void flushSettings(BlockPos pos) {
        if (currentSelection == null) {
            return;
        }
        int removed = 0;
        Iterator<FluidInteractionPoint> iterator = currentSelection.iterator();
        while (iterator.hasNext()) {
            FluidInteractionPoint point = iterator.next();
            if (point.getPos().closerThan((Vec3i)pos, (double)PipetteBlockEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (removed > 0) {
            CreateLang.builder().translate("fluid.mechanical_pipette.points_outside_range", new Object[]{removed}).style(ChatFormatting.RED).sendStatus((Player)player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (FluidInteractionPoint point : currentSelection) {
                if (point.getMode() == FluidInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                CreateLang.builder().translate("fluid.mechanical_pipette.summary", new Object[]{inputs, outputs}).style(ChatFormatting.WHITE).sendStatus((Player)player);
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PipetteFluidPlacementPacket(currentSelection, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        currentSelection.clear();
        currentItem = null;
    }

    public static void tick() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.getMainHandItem();
        if (!CFBlocks.PIPETTE.isIn(heldItemMainhand)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection.clear();
                currentItem = heldItemMainhand;
            }
            PipetteFluidInteractionPointHandler.drawOutlines(currentSelection);
        }
        PipetteFluidInteractionPointHandler.checkForWrench(heldItemMainhand);
    }

    private static void checkForWrench(ItemStack heldItem) {
        if (!AllItems.WRENCH.isIn(heldItem)) {
            return;
        }
        HitResult objectMouseOver = Minecraft.getInstance().hitResult;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        BlockPos pos = result.getBlockPos();
        BlockEntity be = Minecraft.getInstance().level.getBlockEntity(pos);
        if (!(be instanceof PipetteBlockEntity)) {
            lastBlockPos = -1L;
            currentSelection.clear();
            return;
        }
        if (lastBlockPos == -1L || lastBlockPos != pos.asLong()) {
            currentSelection.clear();
            PipetteBlockEntity pipette = (PipetteBlockEntity)be;
            pipette.inputs.forEach(PipetteFluidInteractionPointHandler::put);
            pipette.outputs.forEach(PipetteFluidInteractionPointHandler::put);
            lastBlockPos = pos.asLong();
        }
        if (lastBlockPos != -1L) {
            PipetteFluidInteractionPointHandler.drawOutlines(currentSelection);
        }
    }

    private static void drawOutlines(Collection<FluidInteractionPoint> selection) {
        Iterator<FluidInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            FluidInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.getBlockState(pos = point.getPos());
            VoxelShape shape = state.getShape((BlockGetter)level, pos);
            if (shape.isEmpty()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB((Object)point, shape.bounds().move(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static void put(FluidInteractionPoint point) {
        currentSelection.add(point);
    }

    private static FluidInteractionPoint remove(BlockPos pos) {
        FluidInteractionPoint result = PipetteFluidInteractionPointHandler.getSelected(pos);
        if (result != null) {
            currentSelection.remove(result);
        }
        return result;
    }

    private static FluidInteractionPoint getSelected(BlockPos pos) {
        for (FluidInteractionPoint point : currentSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    static {
        lastBlockPos = -1L;
    }
}

