/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.handler;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.item.BatonItem;
import com.adonis.fluid.mixin.accessor.ArmBlockEntityAccessor;
import com.adonis.fluid.packet.PipetteFluidPlacementPacket;
import com.adonis.fluid.packet.QuartzLampTogglePacket;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmPlacementPacket;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.depot.EjectorPlacementPacket;
import com.simibubi.create.content.logistics.depot.EntityLauncher;
import com.simibubi.create.content.redstone.RoseQuartzLampBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

@EventBusSubscriber(modid="fluid", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class BatonInteractionHandler {
    private static BlockEntity selectedTarget = null;
    private static BlockPos selectedTargetPos = null;
    private static List<ArmInteractionPoint> currentArmSelection = new ArrayList<ArmInteractionPoint>();
    private static List<FluidInteractionPoint> currentPipetteSelection = new ArrayList<FluidInteractionPoint>();
    private static BlockPos selectedEjectorPos = null;
    private static BlockPos ejectorTargetPos = null;
    private static EntityLauncher launcher = null;
    private static SelectionType selectionType = SelectionType.NONE;
    private static int particleCounter = 0;

    public static boolean isInSelectionMode() {
        return selectionType != SelectionType.NONE;
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.getMainHandItem();
        if (!(heldItem.getItem() instanceof BatonItem)) {
            if (BatonInteractionHandler.isInSelectionMode()) {
                BatonInteractionHandler.cancelSelection();
            }
            return;
        }
        if (BatonInteractionHandler.isInSelectionMode()) {
            particleCounter = (particleCounter + 1) % 1000;
            if (selectedTargetPos != null) {
                BatonInteractionHandler.createContinuousParticles((Level)Minecraft.getInstance().level, selectedTargetPos);
            } else if (selectedEjectorPos != null) {
                BatonInteractionHandler.createContinuousParticles((Level)Minecraft.getInstance().level, selectedEjectorPos);
            }
            if (selectionType == SelectionType.ARM) {
                BatonInteractionHandler.drawArmOutlines(currentArmSelection);
            } else if (selectionType == SelectionType.PIPETTE) {
                BatonInteractionHandler.drawPipetteOutlines(currentPipetteSelection);
            } else if (selectionType == SelectionType.EJECTOR) {
                BatonInteractionHandler.drawEjectorOutlines();
                BatonInteractionHandler.drawEjectorArc();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ItemStack heldItem = player.getMainHandItem();
        if (!(heldItem.getItem() instanceof BatonItem)) {
            return;
        }
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        boolean sneaking = player.isShiftKeyDown();
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof ArmBlockEntity || be instanceof PipetteBlockEntity || be instanceof EjectorBlockEntity || state.getBlock() instanceof RoseQuartzLampBlock) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            if (BatonInteractionHandler.canBeInteractionPoint(level, pos, state)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (AllBlocks.DEPOT.has(state) && !(be instanceof EjectorBlockEntity)) {
            if (!sneaking && BatonInteractionHandler.isInSelectionMode()) {
                if (selectionType == SelectionType.ARM) {
                    BatonInteractionHandler.handleArmPointInteraction(level, pos, state, player);
                } else if (selectionType == SelectionType.PIPETTE) {
                    BatonInteractionHandler.handlePipettePointInteraction(level, pos, state, player);
                } else if (selectionType == SelectionType.EJECTOR) {
                    BatonInteractionHandler.handleEjectorTargetSelection(pos, player, level);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        if (state.getBlock() instanceof RoseQuartzLampBlock) {
            PacketDistributor.sendToServer((CustomPacketPayload)new QuartzLampTogglePacket(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 1.0f, false);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (be instanceof ArmBlockEntity) {
            ArmBlockEntity arm = (ArmBlockEntity)be;
            if (sneaking) {
                BatonInteractionHandler.handleArmDanceToggle(arm, player, level);
            } else {
                BatonInteractionHandler.handleArmTargetClick(be, pos, player, level);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            return;
        }
        if (be instanceof PipetteBlockEntity) {
            if (!sneaking) {
                BatonInteractionHandler.handlePipetteTargetClick(be, pos, player, level);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        if (be instanceof EjectorBlockEntity) {
            if (selectionType == SelectionType.ARM || selectionType == SelectionType.PIPETTE) {
                if (!sneaking) {
                    if (selectionType == SelectionType.ARM) {
                        BatonInteractionHandler.handleArmPointInteraction(level, pos, state, player);
                    } else {
                        BatonInteractionHandler.handlePipettePointInteraction(level, pos, state, player);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
            } else {
                BatonInteractionHandler.handleEjectorClick(be, pos, player, level, sneaking);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
        }
        if (BatonInteractionHandler.isInSelectionMode() && !sneaking) {
            if (selectionType == SelectionType.EJECTOR && selectedEjectorPos != null) {
                BatonInteractionHandler.handleEjectorTargetSelection(pos, player, level);
            } else if (selectionType == SelectionType.ARM) {
                BatonInteractionHandler.handleArmPointInteraction(level, pos, state, player);
            } else if (selectionType == SelectionType.PIPETTE) {
                BatonInteractionHandler.handlePipettePointInteraction(level, pos, state, player);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    private static boolean canBeInteractionPoint(Level level, BlockPos pos, BlockState state) {
        if (ArmInteractionPoint.isInteractable((Level)level, (BlockPos)pos, (BlockState)state)) {
            return true;
        }
        return FluidInteractionPoint.create(level, pos, state) != null;
    }

    private static void handleArmDanceToggle(ArmBlockEntity arm, Player player, Level level) {
        boolean isDancing;
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)arm;
        boolean bl = isDancing = accessor.getPhase() == ArmBlockEntity.Phase.DANCING;
        if (isDancing) {
            accessor.setPhase(ArmBlockEntity.Phase.SEARCH_INPUTS);
            CreateLang.builder().translate("fluid.baton.arm.dance_stopped", new Object[0]).style(ChatFormatting.YELLOW).sendStatus(player);
        } else {
            accessor.setPhase(ArmBlockEntity.Phase.DANCING);
            CreateLang.builder().translate("fluid.baton.arm.dance_started", new Object[0]).style(ChatFormatting.GREEN).sendStatus(player);
        }
        level.playLocalSound((double)arm.getBlockPos().getX() + 0.5, (double)arm.getBlockPos().getY() + 0.5, (double)arm.getBlockPos().getZ() + 0.5, (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.BLOCKS, 0.5f, isDancing ? 0.8f : 1.2f, false);
        BatonInteractionHandler.createDanceToggleParticles(level, arm.getBlockPos());
    }

    private static void handleEjectorClick(BlockEntity be, BlockPos pos, Player player, Level level, boolean sneaking) {
        if (selectionType == SelectionType.EJECTOR && selectedEjectorPos != null && selectedEjectorPos.equals((Object)pos)) {
            BatonInteractionHandler.flushEjectorSettings(pos, player, level);
            return;
        }
        if (selectionType == SelectionType.EJECTOR && selectedEjectorPos != null && !selectedEjectorPos.equals((Object)pos)) {
            BatonInteractionHandler.handleEjectorTargetSelection(pos, player, level);
            return;
        }
        if (selectionType == SelectionType.NONE) {
            selectionType = SelectionType.EJECTOR;
            selectedEjectorPos = pos;
            launcher = null;
            EjectorBlockEntity ejector = (EjectorBlockEntity)be;
            BlockPos targetPos = ejector.getTargetPosition();
            ejectorTargetPos = !targetPos.equals((Object)pos) ? targetPos : null;
            CreateLang.builder().translate("fluid.baton.ejector.click_to_set", new Object[0]).style(ChatFormatting.GOLD).sendStatus(player);
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f, false);
            BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
        }
    }

    private static void handleEjectorTargetSelection(BlockPos pos, Player player, Level level) {
        ejectorTargetPos = pos;
        launcher = null;
        CreateLang.builder().translate("fluid.baton.ejector.target_set", new Object[0]).style(ChatFormatting.GOLD).sendStatus(player);
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.3f, 1.5f, false);
    }

    private static Direction getValidTargetDirection(BlockPos ejectorPos, BlockPos targetPos) {
        if (targetPos == null) {
            return null;
        }
        if (VecHelper.onSameAxis((BlockPos)ejectorPos, (BlockPos)targetPos, (Direction.Axis)Direction.Axis.Y)) {
            return null;
        }
        int xDiff = targetPos.getX() - ejectorPos.getX();
        int zDiff = targetPos.getZ() - ejectorPos.getZ();
        int max = (Integer)AllConfigs.server().kinetics.maxEjectorDistance.get();
        if (Math.abs(xDiff) > max || Math.abs(zDiff) > max) {
            return null;
        }
        if (xDiff == 0) {
            return Direction.get((Direction.AxisDirection)(zDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.Z);
        }
        if (zDiff == 0) {
            return Direction.get((Direction.AxisDirection)(xDiff < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)Direction.Axis.X);
        }
        return null;
    }

    private static void flushEjectorSettings(BlockPos ejectorPos, Player player, Level level) {
        if (ejectorTargetPos == null) {
            CreateLang.builder().translate("fluid.baton.ejector.no_target", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            BatonInteractionHandler.cancelSelection();
            return;
        }
        Direction validDirection = BatonInteractionHandler.getValidTargetDirection(ejectorPos, ejectorTargetPos);
        if (validDirection == null) {
            CreateLang.builder().translate("fluid.baton.ejector.invalid_target", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            BatonInteractionHandler.cancelSelection();
            return;
        }
        int xDiff = ejectorTargetPos.getX() - ejectorPos.getX();
        int zDiff = ejectorTargetPos.getZ() - ejectorPos.getZ();
        int yDiff = ejectorTargetPos.getY() - ejectorPos.getY();
        int horizontalDistance = Math.max(Math.abs(xDiff), Math.abs(zDiff));
        PacketDistributor.sendToServer((CustomPacketPayload)new EjectorPlacementPacket(horizontalDistance, yDiff, ejectorPos, validDirection), (CustomPacketPayload[])new CustomPacketPayload[0]);
        CreateLang.builder().translate("weighted_ejector.targeting", new Object[]{ejectorTargetPos.getX(), ejectorTargetPos.getY(), ejectorTargetPos.getZ()}).style(ChatFormatting.GREEN).sendStatus(player);
        level.playLocalSound((double)ejectorPos.getX() + 0.5, (double)ejectorPos.getY() + 0.5, (double)ejectorPos.getZ() + 0.5, (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
        BatonInteractionHandler.cancelSelection();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        ItemStack heldItem = player.getMainHandItem();
        if (!(heldItem.getItem() instanceof BatonItem)) {
            return;
        }
        if (BatonInteractionHandler.isInSelectionMode()) {
            event.setCanceled(true);
            event.setUseBlock(TriState.FALSE);
            event.setUseItem(TriState.FALSE);
            if (event.getLevel().isClientSide) {
                BlockPos pos = event.getPos();
                if (selectionType == SelectionType.EJECTOR) {
                    if (pos.equals((Object)ejectorTargetPos)) {
                        ejectorTargetPos = null;
                        launcher = null;
                        CreateLang.builder().translate("fluid.baton.ejector.target_cleared", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                    }
                } else if (selectionType == SelectionType.ARM) {
                    int sizeBefore = currentArmSelection.size();
                    BatonInteractionHandler.removeArm(pos);
                    if (currentArmSelection.size() < sizeBefore) {
                        CreateLang.builder().translate("fluid.baton.interaction_point_removed", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                        event.getLevel().playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 0.8f, false);
                    }
                } else if (selectionType == SelectionType.PIPETTE) {
                    int sizeBefore = currentPipetteSelection.size();
                    BatonInteractionHandler.removePipette(pos);
                    if (currentPipetteSelection.size() < sizeBefore) {
                        CreateLang.builder().translate("fluid.baton.interaction_point_removed", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                        event.getLevel().playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.5f, 0.8f, false);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem;
        Player player = event.getEntity();
        if (player != null && (heldItem = player.getMainHandItem()).getItem() instanceof BatonItem && BatonInteractionHandler.isInSelectionMode()) {
            event.setCanceled(true);
            event.setNewSpeed(0.0f);
        }
    }

    private static void drawEjectorOutlines() {
        ClientLevel level;
        BlockState state;
        VoxelShape shape;
        if (ejectorTargetPos != null && !(shape = (state = (level = Minecraft.getInstance().level).getBlockState(ejectorTargetPos)).getShape((BlockGetter)level, ejectorTargetPos)).isEmpty()) {
            Outliner.getInstance().showAABB((Object)"ejector_target", shape.bounds().move(ejectorTargetPos)).colored(16763764).lineWidth(0.0625f);
        }
    }

    private static void drawEjectorArc() {
        if (selectedEjectorPos == null || ejectorTargetPos == null) {
            return;
        }
        int xDiff = ejectorTargetPos.getX() - selectedEjectorPos.getX();
        int zDiff = ejectorTargetPos.getZ() - selectedEjectorPos.getZ();
        int yDiff = ejectorTargetPos.getY() - selectedEjectorPos.getY();
        int validX = Math.abs(zDiff) > Math.abs(xDiff) ? 0 : xDiff;
        int validZ = Math.abs(zDiff) < Math.abs(xDiff) ? 0 : zDiff;
        boolean isValid = xDiff == validX && zDiff == validZ;
        int color = isValid ? 10416499 : 16736625;
        Direction validDirection = BatonInteractionHandler.getValidTargetDirection(selectedEjectorPos, ejectorTargetPos);
        if (validDirection == null) {
            if (Math.abs(validX) >= Math.abs(validZ)) {
                validDirection = validX != 0 ? (validX > 0 ? Direction.EAST : Direction.WEST) : Direction.NORTH;
            } else {
                Direction direction = validZ != 0 ? (validZ > 0 ? Direction.SOUTH : Direction.NORTH) : (validDirection = Direction.NORTH);
            }
        }
        if (launcher == null) {
            int horizontalDistance = Math.max(Math.abs(validX), Math.abs(validZ));
            if (horizontalDistance == 0) {
                horizontalDistance = 1;
            }
            launcher = new EntityLauncher(horizontalDistance, yDiff);
        }
        double totalFlyingTicks = launcher.getTotalFlyingTicks() + 3.0;
        int segments = (int)(totalFlyingTicks / 3.0) + 1;
        double tickOffset = totalFlyingTicks / (double)segments;
        Vector3f colorVec = new Color(color).asVectorF();
        DustParticleOptions data = new DustParticleOptions(colorVec, 1.0f);
        ClientLevel world = Minecraft.getInstance().level;
        if (!isValid) {
            BlockPos validPos = selectedEjectorPos.offset(validX - xDiff, -yDiff, validZ - zDiff);
            AABB bb = new AABB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0).move(validPos);
            Outliner.getInstance().chaseAABB((Object)"valid", bb).colored(color).lineWidth(0.0625f);
        }
        for (int i = 0; i < segments; ++i) {
            double ticks = (double)(AnimationTickHolder.getRenderTime() / 3.0f) % tickOffset + (double)i * tickOffset;
            Vec3 vec = launcher.getGlobalPos(ticks, validDirection.getOpposite(), selectedEjectorPos);
            if (!isValid) {
                vec = vec.add((double)(xDiff - validX), 0.0, (double)(zDiff - validZ));
            }
            world.addParticle((ParticleOptions)data, vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
        }
    }

    private static void handleArmTargetClick(BlockEntity be, BlockPos pos, Player player, Level level) {
        if (selectedTarget == be && selectedTargetPos.equals((Object)pos)) {
            BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
            BatonInteractionHandler.flushArmSettings(pos);
            return;
        }
        BatonInteractionHandler.cancelSelection();
        selectedTarget = be;
        selectedTargetPos = pos;
        selectionType = SelectionType.ARM;
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
        ArmBlockEntity arm = (ArmBlockEntity)be;
        currentArmSelection.clear();
        ArmBlockEntityAccessor accessor = (ArmBlockEntityAccessor)arm;
        List<ArmInteractionPoint> inputs = accessor.getInputs();
        List<ArmInteractionPoint> outputs = accessor.getOutputs();
        currentArmSelection.addAll(inputs);
        currentArmSelection.addAll(outputs);
        CreateLang.builder().translate("create.mechanical_arm.summary", new Object[]{inputs.size(), outputs.size()}).style(ChatFormatting.WHITE).sendStatus(player);
    }

    private static void handlePipetteTargetClick(BlockEntity be, BlockPos pos, Player player, Level level) {
        if (selectedTarget == be && selectedTargetPos.equals((Object)pos)) {
            BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
            BatonInteractionHandler.flushPipetteSettings(pos);
            return;
        }
        BatonInteractionHandler.cancelSelection();
        selectedTarget = be;
        selectedTargetPos = pos;
        selectionType = SelectionType.PIPETTE;
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        BatonInteractionHandler.createSelectionSuccessParticles(level, pos);
        PipetteBlockEntity pipette = (PipetteBlockEntity)be;
        currentPipetteSelection.clear();
        currentPipetteSelection.addAll(pipette.inputs);
        currentPipetteSelection.addAll(pipette.outputs);
        CreateLang.builder().translate("fluid.mechanical_pipette.summary", new Object[]{pipette.inputs.size(), pipette.outputs.size()}).style(ChatFormatting.WHITE).sendStatus(player);
    }

    private static void handleArmPointInteraction(Level level, BlockPos pos, BlockState state, Player player) {
        ArmInteractionPoint selected = BatonInteractionHandler.getSelectedArm(pos);
        if (selected == null) {
            ArmInteractionPoint point = ArmInteractionPoint.create((Level)level, (BlockPos)pos, (BlockState)state);
            if (point == null) {
                return;
            }
            selected = point;
            BatonInteractionHandler.putArm(point);
            BatonInteractionHandler.playSelectionEffects(level, pos, true);
        }
        selected.cycleMode();
        ArmInteractionPoint.Mode mode = selected.getMode();
        CreateLang.builder().translate(mode.getTranslationKey(), new Object[]{CreateLang.blockName((BlockState)state).style(ChatFormatting.WHITE)}).color(mode.getColor()).sendStatus(player);
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 2.0f, false);
    }

    private static void flushArmSettings(BlockPos armPos) {
        int removed = 0;
        Iterator<ArmInteractionPoint> iterator = currentArmSelection.iterator();
        while (iterator.hasNext()) {
            ArmInteractionPoint point = iterator.next();
            if (point.getPos().closerThan((Vec3i)armPos, (double)ArmBlockEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (removed > 0) {
            CreateLang.builder().translate("create.mechanical_arm.points_outside_range", new Object[]{removed}).style(ChatFormatting.RED).sendStatus((Player)player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (ArmInteractionPoint point : currentArmSelection) {
                if (point.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                CreateLang.builder().translate("create.mechanical_arm.summary", new Object[]{inputs, outputs}).style(ChatFormatting.WHITE).sendStatus((Player)player);
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ArmPlacementPacket(currentArmSelection, armPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().level.playLocalSound((double)armPos.getX() + 0.5, (double)armPos.getY() + 0.5, (double)armPos.getZ() + 0.5, (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
        BatonInteractionHandler.cancelSelection();
    }

    private static void flushPipetteSettings(BlockPos pipettePos) {
        int removed = 0;
        Iterator<FluidInteractionPoint> iterator = currentPipetteSelection.iterator();
        while (iterator.hasNext()) {
            FluidInteractionPoint point = iterator.next();
            if (point.getPos().closerThan((Vec3i)pipettePos, (double)PipetteBlockEntity.getRange())) continue;
            iterator.remove();
            ++removed;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (removed > 0) {
            CreateLang.builder().translate("fluid.mechanical_pipette.points_outside_range", new Object[]{removed}).style(ChatFormatting.RED).sendStatus((Player)player);
        } else {
            int inputs = 0;
            int outputs = 0;
            for (FluidInteractionPoint point : currentPipetteSelection) {
                if (point.getMode() == FluidInteractionPoint.Mode.DEPOSIT) {
                    ++outputs;
                    continue;
                }
                ++inputs;
            }
            if (inputs + outputs > 0) {
                CreateLang.builder().translate("fluid.mechanical_pipette.summary", new Object[]{inputs, outputs}).style(ChatFormatting.WHITE).sendStatus((Player)player);
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PipetteFluidPlacementPacket(currentPipetteSelection, pipettePos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().level.playLocalSound((double)pipettePos.getX() + 0.5, (double)pipettePos.getY() + 0.5, (double)pipettePos.getZ() + 0.5, (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
        BatonInteractionHandler.cancelSelection();
    }

    private static void handlePipettePointInteraction(Level level, BlockPos pos, BlockState state, Player player) {
        FluidInteractionPoint selected = BatonInteractionHandler.getSelectedPipette(pos);
        if (selected == null) {
            FluidInteractionPoint point = FluidInteractionPoint.create(level, pos, state);
            if (point == null) {
                return;
            }
            selected = point;
            BatonInteractionHandler.putPipette(point);
            BatonInteractionHandler.playSelectionEffects(level, pos, true);
        }
        selected.cycleMode();
        FluidInteractionPoint.Mode mode = selected.getMode();
        CreateLang.builder().translate(mode.getTranslationKey(), new Object[]{CreateLang.blockName((BlockState)state).style(ChatFormatting.WHITE)}).color(mode.getColor()).sendStatus(player);
        level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, 2.0f, false);
    }

    private static void playSelectionEffects(Level level, BlockPos pos, boolean isNew) {
        if (isNew) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.3f, 1.5f, false);
        }
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 0.6;
            double y = (double)pos.getY() + 0.5 + (random.nextDouble() - 0.5) * 0.6;
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 0.6;
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void createSelectionSuccessParticles(Level level, BlockPos pos) {
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            double angle = Math.PI * 2 * (double)i / 20.0;
            double radius = 0.7;
            double x = (double)pos.getX() + 0.5 + Math.cos(angle) * radius;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5 + Math.sin(angle) * radius;
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.5f), x, y, z, 0.0, 0.05, 0.0);
        }
    }

    private static void createDanceToggleParticles(Level level, BlockPos pos) {
        Random random = new Random();
        for (int i = 0; i < 8; ++i) {
            double angle = Math.PI * 2 * (double)i / 8.0;
            double radius = 1.0;
            double x = (double)pos.getX() + 0.5 + Math.cos(angle) * radius;
            double y = (double)pos.getY() + 1.0 + random.nextDouble() * 0.5;
            double z = (double)pos.getZ() + 0.5 + Math.sin(angle) * radius;
            level.addParticle((ParticleOptions)ParticleTypes.NOTE, x, y, z, random.nextDouble(), 0.0, 0.0);
        }
    }

    private static void createContinuousParticles(Level level, BlockPos pos) {
        if (level == null) {
            return;
        }
        Random random = new Random();
        if (particleCounter % 10 == 0) {
            for (int i = 0; i < 6; ++i) {
                double angle = Math.PI * 2 * (double)i / 6.0;
                double radius = 0.7 + random.nextDouble() * 0.2;
                double x = (double)pos.getX() + 0.5 + Math.cos(angle) * radius;
                double y = (double)pos.getY() + 0.5 + random.nextDouble() * 0.8;
                double z = (double)pos.getZ() + 0.5 + Math.sin(angle) * radius;
                level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 0.6f), x, y, z, 0.0, 0.01, 0.0);
            }
        }
    }

    private static void putArm(ArmInteractionPoint point) {
        currentArmSelection.add(point);
    }

    private static void putPipette(FluidInteractionPoint point) {
        currentPipetteSelection.add(point);
    }

    private static ArmInteractionPoint removeArm(BlockPos pos) {
        ArmInteractionPoint result = BatonInteractionHandler.getSelectedArm(pos);
        if (result != null) {
            currentArmSelection.remove(result);
        }
        return result;
    }

    private static FluidInteractionPoint removePipette(BlockPos pos) {
        FluidInteractionPoint result = BatonInteractionHandler.getSelectedPipette(pos);
        if (result != null) {
            currentPipetteSelection.remove(result);
        }
        return result;
    }

    private static ArmInteractionPoint getSelectedArm(BlockPos pos) {
        for (ArmInteractionPoint point : currentArmSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    private static FluidInteractionPoint getSelectedPipette(BlockPos pos) {
        for (FluidInteractionPoint point : currentPipetteSelection) {
            if (!point.getPos().equals((Object)pos)) continue;
            return point;
        }
        return null;
    }

    public static void cancelSelection() {
        selectedTarget = null;
        selectedTargetPos = null;
        selectedEjectorPos = null;
        ejectorTargetPos = null;
        launcher = null;
        selectionType = SelectionType.NONE;
        currentArmSelection.clear();
        currentPipetteSelection.clear();
    }

    private static void drawArmOutlines(List<ArmInteractionPoint> selection) {
        Iterator<ArmInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            ArmInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.getBlockState(pos = point.getPos());
            VoxelShape shape = state.getShape((BlockGetter)level, pos);
            if (shape.isEmpty()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB((Object)point, shape.bounds().move(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static void drawPipetteOutlines(List<FluidInteractionPoint> selection) {
        Iterator<FluidInteractionPoint> iterator = selection.iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            FluidInteractionPoint point = iterator.next();
            if (!point.isValid()) {
                iterator.remove();
                continue;
            }
            Level level = point.getLevel();
            BlockState state = level.getBlockState(pos = point.getPos());
            VoxelShape shape = state.getShape((BlockGetter)level, pos);
            if (shape.isEmpty()) continue;
            int color = point.getMode().getColor();
            Outliner.getInstance().showAABB((Object)point, shape.bounds().move(pos)).colored(color).lineWidth(0.0625f);
        }
    }

    private static enum SelectionType {
        NONE,
        ARM,
        PIPETTE,
        EJECTOR;

    }
}

