/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.content.pipette;

import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ItemDrainFluidInteractionPoint
extends FluidInteractionPoint {
    public ItemDrainFluidInteractionPoint(Level level, BlockPos pos, BlockState state) {
        super(level, pos, state);
        this.mode = FluidInteractionPoint.Mode.TAKE;
        this.face = Direction.DOWN;
    }

    @Override
    public void cycleMode() {
    }

    @Override
    public boolean isValid() {
        if (this.level == null) {
            return false;
        }
        long gameTime = this.level.getGameTime();
        if (gameTime == this.lastKnownValid) {
            return true;
        }
        BlockEntity be = this.level.getBlockEntity(this.pos);
        if (!(be instanceof ItemDrainBlockEntity)) {
            return false;
        }
        this.lastKnownValid = gameTime;
        return true;
    }

    @Override
    public FluidStack extract(int maxAmount, boolean simulate) {
        BlockEntity be = this.level.getBlockEntity(this.pos);
        if (!(be instanceof ItemDrainBlockEntity)) {
            return FluidStack.EMPTY;
        }
        IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.pos, (Object)Direction.DOWN);
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        return handler.drain(maxAmount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public FluidStack insert(FluidStack stack, boolean simulate) {
        return stack;
    }

    @Override
    public boolean canExtract() {
        BlockEntity be = this.level.getBlockEntity(this.pos);
        if (!(be instanceof ItemDrainBlockEntity)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.pos, (Object)Direction.DOWN);
        if (handler == null) {
            return false;
        }
        return !handler.getFluidInTank(0).isEmpty();
    }

    @Override
    public boolean canInsert(FluidStack stack) {
        return false;
    }
}

