/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Pipette;

import com.adonis.fluid.block.Pipette.PipetteBlock;
import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.registry.CFPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PipetteRenderer
extends KineticBlockEntityRenderer<PipetteBlockEntity> {
    public PipetteRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PipetteBlockEntity be, float pt, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        try {
            BlockState state = this.getRenderedBlockState(be);
            RenderType type = this.getRenderType(be, state);
            SuperByteBuffer cogModel = this.getRotatedModel(be, state);
            if (cogModel != null) {
                PipetteRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)cogModel, (PoseStack)ms, (VertexConsumer)buffer.getBuffer(type), (int)light);
            }
            VertexConsumer builder = buffer.getBuffer(RenderType.solid());
            BlockState blockState = be.getBlockState();
            PoseStack msLocal = new PoseStack();
            PoseTransformStack msr = TransformStack.of((PoseStack)msLocal);
            boolean inverted = (Boolean)blockState.getValue((Property)PipetteBlock.CEILING);
            float baseAngle = be.baseAngle.getValue(pt);
            float lowerArmAngle = be.lowerArmAngle.getValue(pt) - 135.0f;
            float upperArmAngle = be.upperArmAngle.getValue(pt) - 90.0f;
            float headAngle = be.headAngle.getValue(pt);
            int color = 0xFFFFFF;
            msr.center();
            if (inverted) {
                msr.rotateXDegrees(180.0f);
            }
            this.renderPipetteSafe(builder, ms, msLocal, (TransformStack)msr, blockState, color, baseAngle, lowerArmAngle, upperArmAngle, headAngle, inverted, light, be);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderPipetteSafe(VertexConsumer builder, PoseStack ms, PoseStack msLocal, TransformStack msr, BlockState blockState, int color, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, boolean inverted, int light, PipetteBlockEntity be) {
        try {
            SuperByteBuffer base = this.getModelSafe(CFPartialModels.PIPETTE_BASE, AllPartialModels.ARM_BASE, blockState, light);
            SuperByteBuffer lowerBody = this.getModelSafe(CFPartialModels.PIPETTE_LOWER_ARM, AllPartialModels.ARM_LOWER_BODY, blockState, light);
            SuperByteBuffer upperBody = this.getModelSafe(CFPartialModels.PIPETTE_UPPER_ARM, AllPartialModels.ARM_UPPER_BODY, blockState, light);
            int fluidAmount = 0;
            if (be != null && !be.heldFluid.isEmpty()) {
                fluidAmount = be.heldFluid.getAmount();
            }
            PartialModel headModel = CFPartialModels.getPipetteHeadForFluidAmount(fluidAmount);
            SuperByteBuffer head = this.getModelSafe(headModel, AllPartialModels.ARM_CLAW_BASE, blockState, light);
            if (base == null || lowerBody == null || upperBody == null || head == null) {
                return;
            }
            ArmRenderer.transformBase((TransformStack)msr, (float)baseAngle);
            ((SuperByteBuffer)base.transform(msLocal)).renderInto(ms, builder);
            ArmRenderer.transformLowerArm((TransformStack)msr, (float)lowerArmAngle);
            ((SuperByteBuffer)lowerBody.color(color).transform(msLocal)).renderInto(ms, builder);
            ArmRenderer.transformUpperArm((TransformStack)msr, (float)upperArmAngle);
            ((SuperByteBuffer)upperBody.color(color).transform(msLocal)).renderInto(ms, builder);
            ArmRenderer.transformHead((TransformStack)msr, (float)headAngle);
            if (inverted) {
                msr.rotateZDegrees(180.0f);
            }
            ((SuperByteBuffer)head.transform(msLocal)).renderInto(ms, builder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SuperByteBuffer getModelSafe(PartialModel model, PartialModel fallback, BlockState blockState, int light) {
        if (model == null) {
            model = fallback;
        }
        SuperByteBuffer buffer = null;
        try {
            buffer = CachedBuffers.partial((PartialModel)model, (BlockState)blockState);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (buffer == null && fallback != null && fallback != model) {
            try {
                buffer = CachedBuffers.partial((PartialModel)fallback, (BlockState)blockState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (buffer != null) {
            buffer.light(light);
        }
        return buffer;
    }

    protected SuperByteBuffer getRotatedModel(PipetteBlockEntity be, BlockState state) {
        try {
            return CachedBuffers.partial((PartialModel)CFPartialModels.PIPETTE_COG, (BlockState)state);
        }
        catch (Exception e) {
            try {
                return CachedBuffers.partial((PartialModel)AllPartialModels.ARM_COG, (BlockState)state);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }
}

