/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Pipette;

import com.adonis.fluid.block.Pipette.PipetteAngleTarget;
import com.adonis.fluid.block.Pipette.PipetteBlock;
import com.adonis.fluid.content.pipette.DepotFluidInteractionPoint;
import com.adonis.fluid.content.pipette.FluidInteractionPoint;
import com.adonis.fluid.content.pipette.IRemoteFluidProcessor;
import com.adonis.fluid.content.pipette.VirtualRelayManager;
import com.adonis.fluid.handler.CFPacketHandler;
import com.adonis.fluid.packet.PipetteParticlePacket;
import com.adonis.fluid.registry.CFBlockEntities;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class PipetteBlockEntity
extends KineticBlockEntity
implements TransformableBlockEntity,
IHaveGoggleInformation,
IRemoteFluidProcessor {
    public List<FluidInteractionPoint> inputs = new ArrayList<FluidInteractionPoint>();
    public List<FluidInteractionPoint> outputs = new ArrayList<FluidInteractionPoint>();
    public ListTag interactionPointTag = null;
    public float chasedPointProgress;
    public int chasedPointIndex;
    public FluidStack heldFluid;
    public Phase phase;
    public boolean goggles;
    PipetteAngleTarget previousTarget;
    public LerpedFloat lowerArmAngle;
    public LerpedFloat upperArmAngle;
    public LerpedFloat baseAngle;
    public LerpedFloat headAngle;
    public LerpedFloat clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    int tooltipWarmup;
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;
    private float previousProgressForInjection = 0.0f;
    private static final int TRANSFER_AMOUNT = 1000;
    private static final int FLUID_CAPACITY = 1000;
    private boolean processingBelt = false;
    private BlockPos processingBeltPos = null;
    private int beltProcessingTicks = 0;
    private boolean isPerformingInjection = false;
    private float injectionStartProgress = 0.8f;
    private boolean continuousProcessing = false;
    private int continuousProcessingCount = 0;
    private static final float HIGH_SPEED_THRESHOLD = 64.0f;
    private static final float LOW_SPEED_THRESHOLD = 32.0f;
    private BlockPos pendingBeltRequest = null;
    private ItemStack pendingBeltItem = ItemStack.EMPTY;

    public PipetteBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.heldFluid = FluidStack.EMPTY;
        this.phase = Phase.SEARCH_INPUTS;
        this.previousTarget = PipetteAngleTarget.NO_TARGET;
        this.baseAngle = LerpedFloat.angular();
        this.baseAngle.startWithValue((double)this.previousTarget.baseAngle);
        this.lowerArmAngle = LerpedFloat.angular();
        this.lowerArmAngle.startWithValue((double)this.previousTarget.lowerArmAngle);
        this.upperArmAngle = LerpedFloat.angular();
        this.upperArmAngle.startWithValue((double)this.previousTarget.upperArmAngle);
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue((double)this.previousTarget.headAngle);
        this.clawAngle = LerpedFloat.angular();
        this.previousBaseAngle = this.previousTarget.baseAngle;
        this.updateInteractionPoints = true;
        this.redstoneLocked = false;
        this.tooltipWarmup = 15;
        this.goggles = false;
    }

    @Override
    public void startFluidProcessing(ItemStack stack, VirtualRelayManager.VirtualRelay relay) {
        if (!this.processingBelt || this.processingBeltPos != null) {
            // empty if block
        }
    }

    @Override
    public boolean isFluidProcessingComplete() {
        return this.beltProcessingTicks <= 0 && !this.isPerformingInjection;
    }

    @Override
    public ItemStack getFluidProcessingResult() {
        return ItemStack.EMPTY;
    }

    @Override
    public void onFluidProcessingComplete() {
        if (this.processingBelt) {
            this.processingBelt = false;
            this.processingBeltPos = null;
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 1);
        }
    }

    public int getFluidCapacity() {
        return 1000;
    }

    public float getWorkProgress() {
        return this.chasedPointProgress;
    }

    @Override
    public FluidStack getHeldFluid() {
        return this.heldFluid.copy();
    }

    public boolean hasFluid() {
        return !this.heldFluid.isEmpty();
    }

    public float getFluidFillRatio() {
        if (this.heldFluid.isEmpty()) {
            return 0.0f;
        }
        return (float)this.heldFluid.getAmount() / 1000.0f;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour(SelectionMode.class, (Component)CreateLang.translateDirect((String)"logistics.when_multiple_outputs_available", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new SelectionModeValueBox(this));
        behaviours.add((BlockEntityBehaviour)this.selectionMode);
    }

    public void tick() {
        super.tick();
        this.initInteractionPoints();
        boolean targetReached = this.tickMovementProgress();
        if (this.tooltipWarmup > 0) {
            --this.tooltipWarmup;
        }
        if (this.chasedPointProgress < 1.0f) {
            FluidInteractionPoint point;
            if (this.phase == Phase.MOVE_TO_INPUT && (point = this.getTargetedInteractionPoint()) != null) {
                point.keepAlive();
            }
        } else if (!this.level.isClientSide) {
            if (this.phase == Phase.MOVE_TO_INPUT) {
                this.collectFluid();
            } else if (this.phase == Phase.MOVE_TO_OUTPUT) {
                this.depositFluid();
            } else if (this.phase == Phase.SEARCH_INPUTS) {
                this.searchForFluid();
            }
            if (targetReached) {
                this.lazyTick();
            }
        }
        this.previousProgressForInjection = this.chasedPointProgress;
        this.handleBeltInjection();
    }

    public void lazyTick() {
        super.lazyTick();
        if (!this.level.isClientSide && this.chasedPointProgress >= 0.5f && this.phase == Phase.SEARCH_OUTPUTS) {
            this.searchForDestination();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(3.0);
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = this.chasedPointProgress >= 1.0f;
        float speed = Math.abs(this.getSpeed());
        float increment = Math.min(256.0f, speed) / 1024.0f;
        if (speed >= 256.0f && increment > 0.2f) {
            increment = 0.2f;
        }
        this.chasedPointProgress += increment;
        if (this.chasedPointProgress > 1.0f) {
            this.chasedPointProgress = 1.0f;
        }
        if (this.level.isClientSide) {
            FluidInteractionPoint targetedInteractionPoint = this.getTargetedInteractionPoint();
            PipetteAngleTarget previousTarget = this.previousTarget;
            PipetteAngleTarget target = targetedInteractionPoint == null ? PipetteAngleTarget.NO_TARGET : this.createAngleTarget(targetedInteractionPoint);
            double currentBaseAngle = AngleHelper.angleLerp((double)this.chasedPointProgress, (double)this.previousBaseAngle, (double)(target == PipetteAngleTarget.NO_TARGET ? (double)this.previousBaseAngle : (double)target.baseAngle));
            this.baseAngle.setValue(currentBaseAngle);
            if (this.chasedPointProgress < 0.5f) {
                target = PipetteAngleTarget.NO_TARGET;
            } else {
                previousTarget = PipetteAngleTarget.NO_TARGET;
            }
            float progress = this.chasedPointProgress == 1.0f ? 1.0f : this.chasedPointProgress % 0.5f * 2.0f;
            double lowerAngle = Mth.lerp((float)progress, (float)previousTarget.lowerArmAngle, (float)target.lowerArmAngle);
            double upperAngle = Mth.lerp((float)progress, (float)previousTarget.upperArmAngle, (float)target.upperArmAngle);
            double headAngleValue = AngleHelper.angleLerp((double)progress, (double)(previousTarget.headAngle % 360.0f), (double)(target.headAngle % 360.0f));
            this.lowerArmAngle.setValue(lowerAngle);
            this.upperArmAngle.setValue(upperAngle);
            this.headAngle.setValue(headAngleValue);
            return false;
        }
        return !targetReachedPreviously && this.chasedPointProgress >= 1.0f;
    }

    protected boolean isOnCeiling() {
        BlockState state = this.getBlockState();
        return this.hasLevel() && state.getOptionalValue((Property)PipetteBlock.CEILING).orElse(false) != false;
    }

    public void setInteractionPointTag(ListTag tag) {
        this.interactionPointTag = tag;
        this.updateInteractionPoints = true;
    }

    public void setUpdateInteractionPoints(boolean update) {
        this.updateInteractionPoints = update;
    }

    public boolean shouldUpdateInteractionPoints() {
        return this.updateInteractionPoints;
    }

    @Nullable
    private FluidInteractionPoint getTargetedInteractionPoint() {
        if (this.chasedPointIndex == -1) {
            return null;
        }
        if (this.phase == Phase.MOVE_TO_INPUT && this.chasedPointIndex < this.inputs.size()) {
            return this.inputs.get(this.chasedPointIndex);
        }
        return this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointIndex < this.outputs.size() ? this.outputs.get(this.chasedPointIndex) : null;
    }

    private PipetteAngleTarget createAngleTarget(FluidInteractionPoint point) {
        return new PipetteAngleTarget(this.worldPosition, VecHelper.getCenterOf((Vec3i)point.getPos()), Direction.DOWN, this.isOnCeiling());
    }

    private boolean canFluidBeOutputted(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return false;
        }
        for (FluidInteractionPoint output : this.outputs) {
            if (!output.isValid() || !output.canInsert(fluid)) continue;
            return true;
        }
        return false;
    }

    protected void searchForFluid() {
        int scanRange;
        if (this.redstoneLocked) {
            return;
        }
        if (!this.heldFluid.isEmpty()) {
            for (FluidInteractionPoint output : this.outputs) {
                if (AllBlocks.BELT.has(this.level.getBlockState(output.getPos()))) continue;
                if (output instanceof DepotFluidInteractionPoint) {
                    DepotFluidInteractionPoint depotPoint = (DepotFluidInteractionPoint)output;
                    if (!depotPoint.hasItemForFilling() || !depotPoint.canInsert(this.heldFluid)) continue;
                    this.phase = Phase.SEARCH_OUTPUTS;
                    this.chasedPointProgress = 0.0f;
                    this.chasedPointIndex = -1;
                    this.searchForDestination();
                    return;
                }
                if (!output.isValid() || !output.canInsert(this.heldFluid)) continue;
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.searchForDestination();
                return;
            }
        }
        boolean foundInput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastInputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastInputIndex + 2 : this.inputs.size();
        if (scanRange > this.inputs.size()) {
            scanRange = this.inputs.size();
        }
        for (int i = startIndex; i < scanRange; ++i) {
            FluidStack simulatedFluid;
            FluidInteractionPoint point = this.inputs.get(i);
            if (!point.isValid() || !point.canExtract() || (simulatedFluid = point.extract(1000, true)).isEmpty()) continue;
            boolean hasValidOutput = false;
            for (FluidInteractionPoint output : this.outputs) {
                if (AllBlocks.BELT.has(this.level.getBlockState(output.getPos())) || !output.isValid() || !output.canInsert(simulatedFluid)) continue;
                hasValidOutput = true;
                break;
            }
            if (!hasValidOutput) continue;
            this.selectIndex(true, i);
            foundInput = true;
            break;
        }
        if (!foundInput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastInputIndex = -1;
        }
        if (this.lastInputIndex == this.inputs.size() - 1) {
            this.lastInputIndex = -1;
        }
    }

    protected void searchForDestination() {
        FluidStack held = this.heldFluid.copy();
        for (int i = 0; i < this.outputs.size(); ++i) {
            FluidInteractionPoint point = this.outputs.get(i);
            BlockState outputState = this.level.getBlockState(point.getPos());
            if (AllBlocks.BELT.has(outputState) || !point.isValid() || !point.canInsert(held)) continue;
            this.selectIndex(false, i);
            break;
        }
    }

    private void selectIndex(boolean input, int index) {
        this.phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        this.chasedPointIndex = index;
        this.chasedPointProgress = 0.0f;
        if (input) {
            this.lastInputIndex = index;
        } else {
            this.lastOutputIndex = index;
        }
        this.sendData();
        this.setChanged();
    }

    protected void depositFluid() {
        FluidInteractionPoint point = this.getTargetedInteractionPoint();
        if (point == null || !point.isValid()) {
            this.phase = this.heldFluid.isEmpty() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
            this.chasedPointProgress = 0.0f;
            this.chasedPointIndex = -1;
            this.sendData();
            this.setChanged();
            return;
        }
        if (point instanceof DepotFluidInteractionPoint) {
            DepotFluidInteractionPoint depotPoint = (DepotFluidInteractionPoint)point;
            DepotBehaviour behaviour = (DepotBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)point.getPos(), (BehaviourType)DepotBehaviour.TYPE);
            if (behaviour == null) {
                return;
            }
            ItemStack itemOnDepot = behaviour.getHeldItemStack();
            if (itemOnDepot != null && !itemOnDepot.isEmpty()) {
                ItemStack singleItem = itemOnDepot.copy();
                singleItem.setCount(1);
                int requiredAmount = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)singleItem, (FluidStack)this.heldFluid);
                if (requiredAmount > 0 && requiredAmount <= this.heldFluid.getAmount()) {
                    FluidStack fluidForParticles = this.heldFluid.copy();
                    fluidForParticles.setAmount(requiredAmount);
                    FluidStack fluidForFilling = this.heldFluid.copy();
                    fluidForFilling.setAmount(requiredAmount);
                    ItemStack result = FillingBySpout.fillItem((Level)this.level, (int)requiredAmount, (ItemStack)singleItem, (FluidStack)fluidForFilling);
                    if (!result.isEmpty()) {
                        itemOnDepot.shrink(1);
                        ArrayList<TransportedItemStack> allStacks = new ArrayList<TransportedItemStack>();
                        if (!itemOnDepot.isEmpty()) {
                            TransportedItemStack remainingStack = new TransportedItemStack(itemOnDepot);
                            remainingStack.beltPosition = 0.5f;
                            remainingStack.prevBeltPosition = 0.5f;
                            allStacks.add(remainingStack);
                        }
                        TransportedItemStack resultStack = new TransportedItemStack(result);
                        resultStack.beltPosition = 0.5f;
                        resultStack.prevBeltPosition = 0.5f;
                        allStacks.add(resultStack);
                        if (!allStacks.isEmpty()) {
                            behaviour.setHeldItem((TransportedItemStack)allStacks.get(0));
                            if (allStacks.size() > 1) {
                                try {
                                    Field bufferField = DepotBehaviour.class.getDeclaredField("processingOutputBuffer");
                                    bufferField.setAccessible(true);
                                    ItemStackHandler outputBuffer = (ItemStackHandler)bufferField.get(behaviour);
                                    for (int i = 1; i < allStacks.size(); ++i) {
                                        ItemStack stackToInsert = ((TransportedItemStack)allStacks.get((int)i)).stack;
                                        for (int slot = 0; slot < outputBuffer.getSlots() && !stackToInsert.isEmpty(); ++slot) {
                                            stackToInsert = outputBuffer.insertItem(slot, stackToInsert, false);
                                        }
                                        if (stackToInsert.isEmpty()) continue;
                                        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)point.getPos());
                                        Containers.dropItemStack((Level)this.level, (double)dropPos.x, (double)(dropPos.y + 0.5), (double)dropPos.z, (ItemStack)stackToInsert);
                                    }
                                }
                                catch (Exception e) {
                                    for (int i = 1; i < allStacks.size(); ++i) {
                                        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)point.getPos());
                                        Containers.dropItemStack((Level)this.level, (double)dropPos.x, (double)(dropPos.y + 0.5), (double)dropPos.z, (ItemStack)((TransportedItemStack)allStacks.get((int)i)).stack);
                                    }
                                }
                            }
                        }
                        behaviour.blockEntity.notifyUpdate();
                        this.heldFluid.shrink(requiredAmount);
                        this.level.playSound(null, point.getPos(), AllSoundEvents.SPOUTING.getMainEvent(), SoundSource.BLOCKS, 0.75f, 0.9f + 0.2f * this.level.random.nextFloat());
                        if (!this.level.isClientSide && !fluidForParticles.isEmpty()) {
                            this.sendFillingParticles(point.getPos(), fluidForParticles);
                        }
                    }
                }
            }
        } else {
            FluidStack remainder;
            FluidStack toInsert = this.heldFluid.copy();
            this.heldFluid = remainder = point.insert(toInsert, false);
        }
        this.phase = this.heldFluid.isEmpty() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.setChanged();
    }

    private void sendFillingParticles(BlockPos targetPos, FluidStack fluid) {
        if (this.level.isClientSide) {
            return;
        }
        if (fluid.isEmpty()) {
            return;
        }
        Vec3 particlePos = VecHelper.getCenterOf((Vec3i)targetPos).add(0.0, 0.8125, 0.0);
        PipetteParticlePacket packet = new PipetteParticlePacket(particlePos, fluid);
        try {
            CFPacketHandler.sendToPlayersTrackingChunk((ServerLevel)this.level, new ChunkPos(targetPos), packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void collectFluid() {
        FluidInteractionPoint point = this.getTargetedInteractionPoint();
        if (point != null && point.isValid()) {
            int maxCanExtract = 1000;
            if (!this.heldFluid.isEmpty() && (maxCanExtract = 1000 - this.heldFluid.getAmount()) <= 0) {
                if (this.pendingBeltRequest != null) {
                    for (int i = 0; i < this.outputs.size(); ++i) {
                        if (!this.outputs.get(i).getPos().equals((Object)this.pendingBeltRequest)) continue;
                        this.phase = Phase.MOVE_TO_OUTPUT;
                        this.chasedPointIndex = i;
                        this.chasedPointProgress = 0.0f;
                        this.processingBelt = true;
                        this.processingBeltPos = this.pendingBeltRequest;
                        this.pendingBeltRequest = null;
                        this.pendingBeltItem = ItemStack.EMPTY;
                        this.sendData();
                        this.setChanged();
                        return;
                    }
                }
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.setChanged();
                return;
            }
            int extractAmount = Math.min(1000, maxCanExtract);
            FluidStack extracted = point.extract(extractAmount, false);
            if (!extracted.isEmpty()) {
                if (!this.heldFluid.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)this.heldFluid, (FluidStack)extracted)) {
                    this.heldFluid.grow(extracted.getAmount());
                } else if (this.heldFluid.isEmpty()) {
                    this.heldFluid = extracted;
                }
                if (this.pendingBeltRequest != null) {
                    for (int i = 0; i < this.outputs.size(); ++i) {
                        if (!this.outputs.get(i).getPos().equals((Object)this.pendingBeltRequest)) continue;
                        this.phase = Phase.MOVE_TO_OUTPUT;
                        this.chasedPointIndex = i;
                        this.chasedPointProgress = 0.0f;
                        this.processingBelt = true;
                        this.processingBeltPos = this.pendingBeltRequest;
                        this.pendingBeltRequest = null;
                        this.pendingBeltItem = ItemStack.EMPTY;
                        this.sendData();
                        this.setChanged();
                        this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 0.125f, 0.5f + this.level.random.nextFloat() * 0.25f);
                        return;
                    }
                }
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.setChanged();
                this.level.playSound(null, this.worldPosition, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 0.125f, 0.5f + this.level.random.nextFloat() * 0.25f);
                return;
            }
        }
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.pendingBeltRequest = null;
        this.pendingBeltItem = ItemStack.EMPTY;
        this.sendData();
        this.setChanged();
    }

    public void redstoneUpdate() {
        boolean blockPowered;
        if (!this.level.isClientSide && (blockPowered = this.level.hasNeighborSignal(this.worldPosition)) != this.redstoneLocked) {
            this.redstoneLocked = blockPowered;
            this.sendData();
            if (!this.redstoneLocked) {
                this.searchForFluid();
            }
        }
    }

    public void resetMovementState() {
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
    }

    public void forceInitInteractionPoints() {
        this.initInteractionPoints();
    }

    public void forceReloadInteractionPoints() {
        if (this.interactionPointTag != null && this.level != null) {
            this.inputs.clear();
            this.outputs.clear();
            for (Tag tag : this.interactionPointTag) {
                FluidInteractionPoint point = FluidInteractionPoint.deserialize((CompoundTag)tag, this.level, this.worldPosition);
                if (point == null) continue;
                if (point.getMode() == FluidInteractionPoint.Mode.TAKE) {
                    this.inputs.add(point);
                    continue;
                }
                this.outputs.add(point);
            }
            this.updateInteractionPoints = false;
            this.sendData();
            this.setChanged();
        }
    }

    public void transform(BlockEntity be, StructureTransform transform) {
        if (this.interactionPointTag != null) {
            for (Tag tag : this.interactionPointTag) {
                FluidInteractionPoint.transformPos((CompoundTag)tag, transform);
            }
            this.notifyUpdate();
        }
    }

    protected boolean isAreaActuallyLoaded(BlockPos center, int range) {
        if (!this.level.isAreaLoaded(center, range)) {
            return false;
        }
        if (this.level.isClientSide) {
            int minY = center.getY() - range;
            int maxY = center.getY() + range;
            if (maxY < this.level.getMinBuildHeight() || minY >= this.level.getMaxBuildHeight()) {
                return false;
            }
            int minX = center.getX() - range;
            int minZ = center.getZ() - range;
            int maxX = center.getX() + range;
            int maxZ = center.getZ() + range;
            int minChunkX = SectionPos.blockToSectionCoord((int)minX);
            int maxChunkX = SectionPos.blockToSectionCoord((int)maxX);
            int minChunkZ = SectionPos.blockToSectionCoord((int)minZ);
            int maxChunkZ = SectionPos.blockToSectionCoord((int)maxZ);
            ChunkSource chunkSource = this.level.getChunkSource();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (chunkSource.hasChunk(chunkX, chunkZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void initInteractionPoints() {
        if (this.updateInteractionPoints && this.interactionPointTag != null && this.isAreaActuallyLoaded(this.worldPosition, PipetteBlockEntity.getRange() + 1)) {
            this.inputs.clear();
            this.outputs.clear();
            for (Tag tag : this.interactionPointTag) {
                FluidInteractionPoint point = FluidInteractionPoint.deserialize((CompoundTag)tag, this.level, this.worldPosition);
                if (point == null) continue;
                if (point.getMode() == FluidInteractionPoint.Mode.DEPOSIT) {
                    this.outputs.add(point);
                    continue;
                }
                if (point.getMode() != FluidInteractionPoint.Mode.TAKE) continue;
                this.inputs.add(point);
            }
            this.updateInteractionPoints = false;
            if (!this.level.isClientSide) {
                VirtualRelayManager.updateWorkstationRelays(this.worldPosition, this.level);
            }
            this.sendData();
            this.setChanged();
        }
    }

    public void writeInteractionPoints(CompoundTag compound) {
        if (this.updateInteractionPoints && this.interactionPointTag != null) {
            compound.put("InteractionPoints", (Tag)this.interactionPointTag);
        } else {
            ListTag pointsNBT = new ListTag();
            this.inputs.stream().map(fip -> fip.serialize(this.worldPosition)).forEach(arg_0 -> pointsNBT.add(arg_0));
            this.outputs.stream().map(fip -> fip.serialize(this.worldPosition)).forEach(arg_0 -> pointsNBT.add(arg_0));
            compound.put("InteractionPoints", (Tag)pointsNBT);
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.writeInteractionPoints(compound);
        NBTHelper.writeEnum((CompoundTag)compound, (String)"Phase", (Enum)this.phase);
        compound.putBoolean("Powered", this.redstoneLocked);
        compound.putBoolean("Goggles", this.goggles);
        if (!this.heldFluid.isEmpty()) {
            compound.put("HeldFluid", this.heldFluid.save(registries));
        } else {
            compound.putBoolean("EmptyFluid", true);
        }
        compound.putInt("TargetPointIndex", this.chasedPointIndex);
        compound.putFloat("MovementProgress", this.chasedPointProgress);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        boolean tagChanged;
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        ListTag interactionPointTagBefore = this.interactionPointTag;
        super.read(compound, registries, clientPacket);
        this.heldFluid = compound.contains("EmptyFluid") && compound.getBoolean("EmptyFluid") ? FluidStack.EMPTY : (compound.contains("HeldFluid") ? FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("HeldFluid")) : FluidStack.EMPTY);
        this.phase = (Phase)NBTHelper.readEnum((CompoundTag)compound, (String)"Phase", Phase.class);
        this.chasedPointIndex = compound.getInt("TargetPointIndex");
        this.chasedPointProgress = compound.getFloat("MovementProgress");
        this.interactionPointTag = compound.getList("InteractionPoints", 10);
        this.redstoneLocked = compound.getBoolean("Powered");
        boolean hadGoggles = this.goggles;
        this.goggles = compound.getBoolean("Goggles");
        if (!clientPacket) {
            return;
        }
        if (hadGoggles != this.goggles && this.level != null && this.level.isClientSide) {
            VisualizationHelper.queueUpdate((BlockEntity)this);
        }
        boolean bl = tagChanged = interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size();
        if (tagChanged) {
            this.updateInteractionPoints = true;
        }
        if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
            FluidInteractionPoint targetedPoint;
            FluidInteractionPoint previousPoint = null;
            if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                previousPoint = this.inputs.get(previousIndex);
            }
            if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                previousPoint = this.outputs.get(previousIndex);
            }
            PipetteAngleTarget pipetteAngleTarget = this.previousTarget = previousPoint == null ? PipetteAngleTarget.NO_TARGET : this.createAngleTarget(previousPoint);
            if (previousPoint != null) {
                this.previousBaseAngle = this.previousTarget.baseAngle;
            }
            if ((targetedPoint = this.getTargetedInteractionPoint()) != null) {
                targetedPoint.updateCachedState();
            }
        }
    }

    public void writeSafe(CompoundTag compound, HolderLookup.Provider registries) {
        super.writeSafe(compound, registries);
        this.writeInteractionPoints(compound);
        if (!this.heldFluid.isEmpty()) {
            compound.put("HeldFluid", this.heldFluid.save(registries));
        } else {
            compound.putBoolean("EmptyFluid", true);
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        ListTag interactionPointTagBefore = this.interactionPointTag;
        super.loadAdditional(compound, registries);
        this.heldFluid = compound.contains("EmptyFluid") && compound.getBoolean("EmptyFluid") ? FluidStack.EMPTY : (compound.contains("HeldFluid") ? FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("HeldFluid")) : FluidStack.EMPTY);
        this.phase = (Phase)NBTHelper.readEnum((CompoundTag)compound, (String)"Phase", Phase.class);
        this.chasedPointIndex = compound.getInt("TargetPointIndex");
        this.chasedPointProgress = compound.getFloat("MovementProgress");
        this.interactionPointTag = compound.getList("InteractionPoints", 10);
        this.redstoneLocked = compound.getBoolean("Powered");
        boolean hadGoggles = this.goggles;
        this.goggles = compound.getBoolean("Goggles");
        if (this.level != null && this.level.isClientSide) {
            boolean tagChanged;
            if (hadGoggles != this.goggles && this.level.isClientSide) {
                VisualizationHelper.queueUpdate((BlockEntity)this);
            }
            boolean forceUpdate = compound.getBoolean("ForceUpdate");
            boolean bl = tagChanged = interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size();
            if (forceUpdate || tagChanged) {
                this.inputs.clear();
                this.outputs.clear();
                if (this.interactionPointTag != null && this.level != null) {
                    for (Tag tag : this.interactionPointTag) {
                        FluidInteractionPoint point = FluidInteractionPoint.deserialize((CompoundTag)tag, this.level, this.worldPosition);
                        if (point == null) continue;
                        if (point.getMode() == FluidInteractionPoint.Mode.TAKE) {
                            this.inputs.add(point);
                            continue;
                        }
                        this.outputs.add(point);
                    }
                }
                this.updateInteractionPoints = false;
            }
            if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
                FluidInteractionPoint targetedPoint;
                FluidInteractionPoint previousPoint = null;
                if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                    previousPoint = this.inputs.get(previousIndex);
                }
                if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                    previousPoint = this.outputs.get(previousIndex);
                }
                PipetteAngleTarget pipetteAngleTarget = this.previousTarget = previousPoint == null ? PipetteAngleTarget.NO_TARGET : this.createAngleTarget(previousPoint);
                if (previousPoint != null) {
                    this.previousBaseAngle = this.previousTarget.baseAngle;
                }
                if ((targetedPoint = this.getTargetedInteractionPoint()) != null) {
                    targetedPoint.updateCachedState();
                }
            }
        }
    }

    public static int getRange() {
        return (Integer)AllConfigs.server().logistics.mechanicalArmRange.get();
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (this.tooltipWarmup > 0) {
            return false;
        }
        if (!this.inputs.isEmpty()) {
            return false;
        }
        if (!this.outputs.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, (String)"fluid.mechanical_pipette.no_targets", (Object[])new Object[0]);
        return true;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition, null);
        if (handler != null) {
            return this.containedFluidTooltip(tooltip, isPlayerSneaking, handler) || added;
        }
        return added;
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        for (FluidInteractionPoint input : this.inputs) {
            input.setLevel(level);
        }
        for (FluidInteractionPoint output : this.outputs) {
            output.setLevel(level);
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CFBlockEntities.PIPETTE.get(), (be, side) -> new IFluidHandler((PipetteBlockEntity)be){
            final /* synthetic */ PipetteBlockEntity val$be;
            {
                this.val$be = pipetteBlockEntity;
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return this.val$be.heldFluid.copy();
            }

            public int getTankCapacity(int tank) {
                return 1000;
            }

            public boolean isFluidValid(int tank, FluidStack stack) {
                return true;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource.isEmpty()) {
                    return 0;
                }
                int canFill = Math.min(resource.getAmount(), 1000 - this.val$be.heldFluid.getAmount());
                if (canFill <= 0) {
                    return 0;
                }
                if (action.execute()) {
                    if (this.val$be.heldFluid.isEmpty()) {
                        this.val$be.heldFluid = resource.copy();
                        this.val$be.heldFluid.setAmount(canFill);
                    } else if (FluidStack.isSameFluidSameComponents((FluidStack)this.val$be.heldFluid, (FluidStack)resource)) {
                        this.val$be.heldFluid.grow(canFill);
                    } else {
                        return 0;
                    }
                    this.val$be.setChanged();
                    this.val$be.sendData();
                }
                return canFill;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.val$be.heldFluid)) {
                    return FluidStack.EMPTY;
                }
                return this.drain(resource.getAmount(), action);
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (this.val$be.heldFluid.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                int drained = Math.min(maxDrain, this.val$be.heldFluid.getAmount());
                FluidStack result = this.val$be.heldFluid.copy();
                result.setAmount(drained);
                if (action.execute()) {
                    this.val$be.heldFluid.shrink(drained);
                    this.val$be.setChanged();
                    this.val$be.sendData();
                }
                return result;
            }
        });
    }

    public SpeedMode getSpeedMode() {
        float speed = Math.abs(this.getSpeed());
        if (speed < 32.0f) {
            return SpeedMode.ULTRA_LOW;
        }
        if (speed < 64.0f) {
            return SpeedMode.LOW;
        }
        return SpeedMode.HIGH;
    }

    public boolean isHighSpeed() {
        return this.getSpeedMode() == SpeedMode.HIGH;
    }

    public boolean isReadyToInject() {
        return this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointProgress >= this.injectionStartProgress;
    }

    public boolean willReachInjectionPoint() {
        if (this.phase != Phase.MOVE_TO_OUTPUT) {
            return false;
        }
        if (!this.isHighSpeed()) {
            return false;
        }
        float speed = Math.abs(this.getSpeed());
        float increment = Math.min(256.0f, speed) / 1024.0f;
        if (speed >= 256.0f && increment > 0.2f) {
            increment = 0.2f;
        }
        float nextProgress = this.chasedPointProgress + increment;
        return this.chasedPointProgress < this.injectionStartProgress && nextProgress >= this.injectionStartProgress;
    }

    public void notifyRelayInjectionReady(BlockPos beltPos) {
        VirtualRelayManager.notifyInjectionReady(beltPos);
    }

    public boolean isContinuousProcessing() {
        return this.continuousProcessing;
    }

    public void startContinuousProcessing() {
        this.continuousProcessing = true;
        this.continuousProcessingCount = 0;
    }

    public void incrementContinuousProcessing() {
        ++this.continuousProcessingCount;
    }

    public void endContinuousProcessing() {
        this.continuousProcessing = false;
        this.continuousProcessingCount = 0;
    }

    @Override
    public boolean canProcessFluidItem(ItemStack stack) {
        if (this.heldFluid.isEmpty()) {
            return false;
        }
        if (!FillingBySpout.canItemBeFilled((Level)this.level, (ItemStack)stack)) {
            return false;
        }
        int required = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)stack, (FluidStack)this.heldFluid);
        return required > 0 && required <= this.heldFluid.getAmount();
    }

    @Override
    public void syncFluid(FluidStack fluid) {
        this.heldFluid = fluid.copy();
        this.sendData();
        this.setChanged();
    }

    @Override
    public boolean requestFluidForItem(ItemStack stack, BlockPos sourcePos) {
        int required;
        if (!this.heldFluid.isEmpty() && (required = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)stack, (FluidStack)this.heldFluid)) > 0 && required <= this.heldFluid.getAmount()) {
            for (int i = 0; i < this.outputs.size(); ++i) {
                if (!this.outputs.get(i).getPos().equals((Object)sourcePos)) continue;
                this.phase = Phase.MOVE_TO_OUTPUT;
                this.chasedPointIndex = i;
                this.chasedPointProgress = 0.0f;
                this.processingBelt = true;
                this.processingBeltPos = sourcePos;
                this.sendData();
                this.setChanged();
                return true;
            }
            return true;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            int required2;
            FluidStack simulatedFluid;
            FluidInteractionPoint input = this.inputs.get(i);
            if (!input.isValid() || !input.canExtract() || (simulatedFluid = input.extract(1000, true)).isEmpty() || (required2 = FillingBySpout.getRequiredAmountForItem((Level)this.level, (ItemStack)stack, (FluidStack)simulatedFluid)) <= 0 || required2 > simulatedFluid.getAmount()) continue;
            this.pendingBeltRequest = sourcePos;
            this.pendingBeltItem = stack.copy();
            this.phase = Phase.MOVE_TO_INPUT;
            this.chasedPointIndex = i;
            this.chasedPointProgress = 0.0f;
            this.lastInputIndex = i;
            this.sendData();
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public void notifyProcessingStarted(BlockPos beltPos) {
        this.startBeltProcessing(beltPos);
    }

    @Override
    public void notifyProcessingCompleted(BlockPos beltPos) {
        this.processingBelt = false;
        this.processingBeltPos = null;
        this.beltProcessingTicks = 0;
        this.isPerformingInjection = false;
    }

    @Override
    public int getProcessingRange() {
        return PipetteBlockEntity.getRange();
    }

    public void startBeltProcessing(BlockPos beltPos) {
        this.processingBelt = true;
        this.processingBeltPos = beltPos;
        this.isPerformingInjection = false;
        for (int i = 0; i < this.outputs.size(); ++i) {
            if (!this.outputs.get(i).getPos().equals((Object)beltPos)) continue;
            this.phase = Phase.MOVE_TO_OUTPUT;
            this.chasedPointIndex = i;
            if (!(this.chasedPointProgress >= 1.0f)) break;
            this.chasedPointProgress = 0.0f;
            break;
        }
        this.sendData();
    }

    public void onBeltProcessingFinished(BlockPos beltPos) {
        this.processingBelt = false;
        this.processingBeltPos = null;
        this.beltProcessingTicks = 0;
        this.isPerformingInjection = false;
        if (!this.heldFluid.isEmpty()) {
            this.phase = Phase.SEARCH_OUTPUTS;
            this.chasedPointProgress = 0.0f;
            this.chasedPointIndex = -1;
        } else {
            this.phase = Phase.SEARCH_INPUTS;
            this.chasedPointProgress = 0.0f;
            this.chasedPointIndex = -1;
        }
        this.sendData();
        this.setChanged();
    }

    public void sendBeltProcessingEffects(BlockPos beltPos, FluidStack fluid) {
        if (!this.level.isClientSide && !fluid.isEmpty()) {
            Vec3 particlePos = VecHelper.getCenterOf((Vec3i)beltPos).add(0.0, 0.5, 0.0);
            PipetteParticlePacket packet = new PipetteParticlePacket(particlePos, fluid);
            CFPacketHandler.sendToPlayersTrackingChunk((ServerLevel)this.level, new ChunkPos(beltPos), packet);
        }
    }

    private void handleBeltInjection() {
        SpeedMode mode = this.getSpeedMode();
        switch (mode.ordinal()) {
            case 2: {
                this.handleHighSpeedInjection();
                break;
            }
            case 1: {
                this.handleLowSpeedInjection();
                break;
            }
            case 0: {
                this.handleUltraLowSpeedInjection();
            }
        }
        if (this.processingBelt && this.beltProcessingTicks > 0) {
            --this.beltProcessingTicks;
            if (this.beltProcessingTicks == 15) {
                this.level.playSound(null, this.processingBeltPos, AllSoundEvents.SPOUTING.getMainEvent(), SoundSource.BLOCKS, 0.75f, 0.9f + 0.2f * this.level.random.nextFloat());
            }
        }
    }

    private void handleHighSpeedInjection() {
        this.injectionStartProgress = 0.8f;
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.processingBelt) {
            if (!this.isPerformingInjection && this.chasedPointProgress >= this.injectionStartProgress) {
                this.isPerformingInjection = true;
                this.notifyRelayInjectionReady(this.processingBeltPos);
            }
            if (this.chasedPointProgress >= 1.0f) {
                this.isPerformingInjection = false;
            }
        }
    }

    private void handleLowSpeedInjection() {
        this.injectionStartProgress = 0.6f;
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.processingBelt) {
            if (this.chasedPointProgress >= 0.9f && this.continuousProcessing) {
                this.chasedPointProgress = 1.0f;
            }
            if (!this.isPerformingInjection && this.chasedPointProgress >= this.injectionStartProgress) {
                this.isPerformingInjection = true;
                this.notifyRelayInjectionReady(this.processingBeltPos);
                if (!this.level.isClientSide) {
                    this.beltProcessingTicks = 30;
                }
            }
            if (this.chasedPointProgress >= 1.0f && !this.continuousProcessing) {
                this.isPerformingInjection = false;
            }
        }
    }

    private void handleUltraLowSpeedInjection() {
        this.injectionStartProgress = 0.3f;
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.processingBelt) {
            if (!this.isPerformingInjection && this.chasedPointProgress > 0.1f) {
                this.isPerformingInjection = true;
                this.notifyRelayInjectionReady(this.processingBeltPos);
                if (!this.level.isClientSide) {
                    float speed = Math.abs(this.getSpeed());
                    int ticksToComplete = (int)((1.0f - this.chasedPointProgress) * 1024.0f / Math.max(speed, 1.0f));
                    this.beltProcessingTicks = Math.max(ticksToComplete + 10, 40);
                }
            }
            if (this.chasedPointProgress >= 1.0f) {
                this.isPerformingInjection = false;
            }
        }
    }

    public void invalidate() {
        super.invalidate();
        if (!this.level.isClientSide) {
            VirtualRelayManager.unregisterWorkstation(this.worldPosition);
        }
    }

    public void destroy() {
        super.destroy();
        if (!this.level.isClientSide) {
            VirtualRelayManager.unregisterWorkstation(this.worldPosition);
        }
    }

    public static enum Phase {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT;

    }

    public static enum SelectionMode implements INamedIconOptions
    {
        ROUND_ROBIN(AllIcons.I_ARM_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_ARM_FORCED_ROUND_ROBIN),
        PREFER_FIRST(AllIcons.I_ARM_PREFER_FIRST);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "create.mechanical_arm.selection_mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class SelectionModeValueBox
    extends CenteredSideValueBoxTransform {
        public SelectionModeValueBox(PipetteBlockEntity pipetteBlockEntity) {
            super((blockState, direction) -> !direction.getAxis().isVertical());
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            int yPos = (Boolean)state.getValue((Property)PipetteBlock.CEILING) != false ? 13 : 3;
            Vec3 location = VecHelper.voxelSpace((double)8.0, (double)yPos, (double)15.5);
            location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)this.getSide()), (Direction.Axis)Direction.Axis.Y);
            return location;
        }

        public float getScale() {
            return super.getScale();
        }
    }

    public static enum SpeedMode {
        ULTRA_LOW,
        LOW,
        HIGH;

    }
}

