/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.Pipette;

import com.adonis.fluid.block.Pipette.PipetteBlockEntity;
import com.adonis.fluid.registry.CFBlockEntities;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipetteBlock
extends KineticBlock
implements IBE<PipetteBlockEntity>,
ICogWheel {
    public static final MapCodec<PipetteBlock> CODEC = PipetteBlock.simpleCodec(PipetteBlock::new);
    public static final BooleanProperty CEILING = BooleanProperty.create((String)"ceiling");

    public PipetteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CEILING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends KineticBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{CEILING}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)CEILING, (Comparable)Boolean.valueOf(ctx.getClickedFace() == Direction.DOWN));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)CEILING) != false ? AllShapes.MECHANICAL_ARM_CEILING : AllShapes.MECHANICAL_ARM;
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)CEILING) != false ? AllShapes.MECHANICAL_ARM_CEILING : AllShapes.MECHANICAL_ARM;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        this.withBlockEntityDo((BlockGetter)world, pos, PipetteBlockEntity::redstoneUpdate);
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.withBlockEntityDo((BlockGetter)world, pos, PipetteBlockEntity::redstoneUpdate);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public Class<PipetteBlockEntity> getBlockEntityClass() {
        return PipetteBlockEntity.class;
    }

    public BlockEntityType<? extends PipetteBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CFBlockEntities.PIPETTE.get();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (AllItems.GOGGLES.isIn(stack)) {
            return this.onBlockEntityUse((BlockGetter)world, pos, be -> {
                if (be.goggles) {
                    return InteractionResult.PASS;
                }
                be.goggles = true;
                be.notifyUpdate();
                return InteractionResult.SUCCESS;
            }) == InteractionResult.SUCCESS ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() == Items.BUCKET) {
            InteractionResult result = this.onBlockEntityUse((BlockGetter)world, pos, be -> {
                if (!be.heldFluid.isEmpty() && be.heldFluid.getAmount() >= 1000) {
                    if (!world.isClientSide) {
                        if (player.isCreative()) {
                            be.heldFluid.shrink(1000);
                            if (be.heldFluid.isEmpty()) {
                                be.phase = PipetteBlockEntity.Phase.SEARCH_INPUTS;
                            }
                            be.setChanged();
                            be.sendData();
                            world.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            ItemStack filledBucket = new ItemStack((ItemLike)be.heldFluid.getFluid().getBucket());
                            if (filledBucket.getItem() == Items.BUCKET) {
                                return InteractionResult.PASS;
                            }
                            be.heldFluid.shrink(1000);
                            if (be.heldFluid.isEmpty()) {
                                be.phase = PipetteBlockEntity.Phase.SEARCH_INPUTS;
                            }
                            be.setChanged();
                            be.sendData();
                            stack.shrink(1);
                            if (stack.isEmpty()) {
                                player.setItemInHand(hand, filledBucket);
                            } else if (!player.getInventory().add(filledBucket)) {
                                player.drop(filledBucket, false);
                            }
                            world.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            });
            return result == InteractionResult.SUCCESS ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

