/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.FluidInterface;

import com.adonis.fluid.block.FluidInterface.FluidInterfaceBlock;
import com.adonis.fluid.registry.CFBlockEntities;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidInterfaceBlockEntity
extends SmartBlockEntity {
    public FluidInterfaceBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private boolean isCopperGrate(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.COPPER_GRATE || block == Blocks.EXPOSED_COPPER_GRATE || block == Blocks.WEATHERED_COPPER_GRATE || block == Blocks.OXIDIZED_COPPER_GRATE || block == Blocks.WAXED_COPPER_GRATE || block == Blocks.WAXED_EXPOSED_COPPER_GRATE || block == Blocks.WAXED_WEATHERED_COPPER_GRATE || block == Blocks.WAXED_OXIDIZED_COPPER_GRATE;
    }

    @Nullable
    public IFluidHandler getTargetFluidHandler() {
        if (this.level == null) {
            return null;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof FluidInterfaceBlock)) {
            return null;
        }
        Direction attachedDirection = ((Direction)state.getValue((Property)FluidInterfaceBlock.FACING)).getOpposite();
        BlockPos targetPos = this.worldPosition.relative(attachedDirection);
        IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, targetPos, (Object)((Direction)state.getValue((Property)FluidInterfaceBlock.FACING)));
        if (handler == null) {
            handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, targetPos, null);
        }
        return handler;
    }

    @Nullable
    public BlockEntity getTargetBlockEntity() {
        if (this.level == null) {
            return null;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof FluidInterfaceBlock)) {
            return null;
        }
        Direction attachedDirection = ((Direction)state.getValue((Property)FluidInterfaceBlock.FACING)).getOpposite();
        BlockPos targetPos = this.worldPosition.relative(attachedDirection);
        return this.level.getBlockEntity(targetPos);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CFBlockEntities.FLUID_INTERFACE.get(), (be, side) -> {
            IFluidHandler targetHandler = be.getTargetFluidHandler();
            if (targetHandler != null) {
                return targetHandler;
            }
            BlockState state = be.getBlockState();
            Direction attachedDirection = ((Direction)state.getValue((Property)FluidInterfaceBlock.FACING)).getOpposite();
            BlockPos targetPos = be.worldPosition.relative(attachedDirection);
            BlockState targetState = be.level.getBlockState(targetPos);
            if ((targetState.is(BlockTags.LEAVES) || be.isCopperGrate(targetState)) && targetState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)targetState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                return new WaterloggedBlockFluidHandler();
            }
            return null;
        });
    }

    private static class WaterloggedBlockFluidHandler
    implements IFluidHandler {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.WATER, 1000);

        private WaterloggedBlockFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return WATER.copy();
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.WATER) {
                return new FluidStack((Fluid)Fluids.WATER, Math.min(resource.getAmount(), 1000));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.WATER, Math.min(maxDrain, 1000));
        }
    }
}

