/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.FluidInterface;

import com.adonis.fluid.block.FluidInterface.FluidInterfaceBlockEntity;
import com.adonis.fluid.registry.CFBlockEntities;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.fluid.FluidHelper;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidInterfaceBlock
extends HorizontalDirectionalBlock
implements IBE<FluidInterfaceBlockEntity>,
IWrenchable {
    public static final MapCodec<FluidInterfaceBlock> CODEC = FluidInterfaceBlock.simpleCodec(FluidInterfaceBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape NORTH_LAYER_1 = Block.box((double)3.0, (double)3.0, (double)14.0, (double)13.0, (double)12.9, (double)16.0);
    private static final VoxelShape NORTH_LAYER_2 = Block.box((double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape NORTH_LAYER_3 = Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)13.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)NORTH_LAYER_1, (VoxelShape[])new VoxelShape[]{NORTH_LAYER_2, NORTH_LAYER_3});
    private static final VoxelShape SOUTH_LAYER_1 = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)12.9, (double)2.0);
    private static final VoxelShape SOUTH_LAYER_2 = Block.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)3.0);
    private static final VoxelShape SOUTH_LAYER_3 = Block.box((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)5.0);
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)SOUTH_LAYER_1, (VoxelShape[])new VoxelShape[]{SOUTH_LAYER_2, SOUTH_LAYER_3});
    private static final VoxelShape EAST_LAYER_1 = Block.box((double)0.0, (double)3.0, (double)3.0, (double)2.0, (double)12.9, (double)13.0);
    private static final VoxelShape EAST_LAYER_2 = Block.box((double)2.0, (double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_LAYER_3 = Block.box((double)3.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)EAST_LAYER_1, (VoxelShape[])new VoxelShape[]{EAST_LAYER_2, EAST_LAYER_3});
    private static final VoxelShape WEST_LAYER_1 = Block.box((double)14.0, (double)3.0, (double)3.0, (double)16.0, (double)12.9, (double)13.0);
    private static final VoxelShape WEST_LAYER_2 = Block.box((double)13.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0);
    private static final VoxelShape WEST_LAYER_3 = Block.box((double)11.0, (double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0);
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)WEST_LAYER_1, (VoxelShape[])new VoxelShape[]{WEST_LAYER_2, WEST_LAYER_3});

    public FluidInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    private boolean isCopperGrate(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.COPPER_GRATE || block == Blocks.EXPOSED_COPPER_GRATE || block == Blocks.WEATHERED_COPPER_GRATE || block == Blocks.OXIDIZED_COPPER_GRATE || block == Blocks.WAXED_COPPER_GRATE || block == Blocks.WAXED_EXPOSED_COPPER_GRATE || block == Blocks.WAXED_WEATHERED_COPPER_GRATE || block == Blocks.WAXED_OXIDIZED_COPPER_GRATE;
    }

    private boolean hasFluidCapability(Level level, BlockPos pos, Direction fromDirection) {
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(BlockTags.LEAVES) || this.isCopperGrate(blockState)) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return false;
        }
        IFluidHandler capability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)fromDirection);
        if (capability != null && capability.getTanks() > 0) {
            return true;
        }
        capability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
        return capability != null && capability.getTanks() > 0;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        BlockPos blockpos = context.getClickedPos();
        BlockPos attachedPos = blockpos.relative(direction.getOpposite());
        Level level = context.getLevel();
        if (this.hasFluidCapability(level, attachedPos, direction)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos testPos = blockpos.relative(dir.getOpposite());
            if (!this.hasFluidCapability(level, testPos, dir)) continue;
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir);
        }
        return null;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos attachedPos = pos.relative(direction.getOpposite());
        BlockState attachedState = level.getBlockState(attachedPos);
        if (attachedState.is(BlockTags.LEAVES) || this.isCopperGrate(attachedState)) {
            return true;
        }
        if (level instanceof Level) {
            Level actualLevel = (Level)level;
            return this.hasFluidCapability(actualLevel, attachedPos, direction);
        }
        return !attachedState.isAir();
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        SoundEvent soundevent;
        FluidHelper.FluidExchange exchange;
        IFluidHandler tankCapability;
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof FakePlayer) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack) && !GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Direction attachedDirection = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos targetPos = pos.relative(attachedDirection);
        BlockState targetState = level.getBlockState(targetPos);
        if ((targetState.is(BlockTags.LEAVES) || this.isCopperGrate(targetState)) && targetState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)targetState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            tankCapability = new WaterloggedBlockFluidHandler();
        } else {
            tankCapability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, targetPos, (Object)((Direction)state.getValue((Property)FACING)));
            if (tankCapability == null) {
                tankCapability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, targetPos, null);
            }
        }
        if (tankCapability == null) {
            return ItemInteractionResult.FAIL;
        }
        FluidStack fluidStack = this.tryEmptyItem(level, player, hand, stack, targetPos, tankCapability);
        if (!fluidStack.isEmpty()) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else {
            fluidStack = this.tryFillItem(level, player, hand, stack, targetPos, tankCapability);
            if (!fluidStack.isEmpty()) {
                exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
            } else {
                return ItemInteractionResult.FAIL;
            }
        }
        switch (exchange) {
            default: {
                throw new MatchException(null, null);
            }
            case ITEM_TO_TANK: {
                SoundEvent soundEvent = FluidHelper.getEmptySound((FluidStack)fluidStack);
                break;
            }
            case TANK_TO_ITEM: {
                SoundEvent soundEvent = soundevent = FluidHelper.getFillSound((FluidStack)fluidStack);
            }
        }
        if (soundevent != null) {
            float pitch = Mth.clamp((float)(1.0f - (float)fluidStack.getAmount() / 16000.0f), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            level.playSound(null, pos, soundevent, SoundSource.BLOCKS, 0.5f, pitch += (level.random.nextFloat() - 0.5f) / 4.0f);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private FluidStack tryEmptyItem(Level level, Player player, InteractionHand hand, ItemStack stack, BlockPos targetPos, IFluidHandler capability) {
        if (!GenericItemEmptying.canItemBeEmptied((Level)level, (ItemStack)stack)) {
            return FluidStack.EMPTY;
        }
        Pair result = GenericItemEmptying.emptyItem((Level)level, (ItemStack)stack, (boolean)true);
        FluidStack fluidStack = (FluidStack)result.getFirst();
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int filled = capability.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (filled != fluidStack.getAmount()) {
            return FluidStack.EMPTY;
        }
        if (level.isClientSide) {
            return fluidStack;
        }
        ItemStack copy = stack.copy();
        result = GenericItemEmptying.emptyItem((Level)level, (ItemStack)copy, (boolean)false);
        ItemStack resultItem = (ItemStack)result.getSecond();
        capability.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
        BlockEntity targetBlockEntity = level.getBlockEntity(targetPos);
        if (targetBlockEntity != null) {
            targetBlockEntity.setChanged();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.getChunkSource().blockChanged(targetPos);
            }
        }
        if (!player.isCreative() && !(targetBlockEntity instanceof CreativeFluidTankBlockEntity)) {
            if (copy.isEmpty()) {
                player.setItemInHand(hand, resultItem);
            } else {
                player.setItemInHand(hand, copy);
                player.getInventory().placeItemBackInInventory(resultItem);
            }
        }
        return fluidStack;
    }

    private FluidStack tryFillItem(Level level, Player player, InteractionHand hand, ItemStack stack, BlockPos targetPos, IFluidHandler capability) {
        if (!GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack)) {
            return FluidStack.EMPTY;
        }
        BlockEntity targetBlockEntity = level.getBlockEntity(targetPos);
        for (int i = 0; i < capability.getTanks(); ++i) {
            int requiredAmount;
            FluidStack fluidStack = capability.getFluidInTank(i);
            if (fluidStack.isEmpty() || (requiredAmount = GenericItemFilling.getRequiredAmountForItem((Level)level, (ItemStack)stack, (FluidStack)fluidStack.copy())) == -1 || requiredAmount > fluidStack.getAmount()) continue;
            if (level.isClientSide) {
                return fluidStack;
            }
            ItemStack fillStack = stack;
            if (player.isCreative() || targetBlockEntity instanceof CreativeFluidTankBlockEntity) {
                fillStack = stack.copy();
            }
            ItemStack result = GenericItemFilling.fillItem((Level)level, (int)requiredAmount, (ItemStack)fillStack, (FluidStack)fluidStack.copy());
            FluidStack drainFluid = fluidStack.copy();
            drainFluid.setAmount(requiredAmount);
            capability.drain(drainFluid, IFluidHandler.FluidAction.EXECUTE);
            if (!player.isCreative()) {
                player.getInventory().placeItemBackInInventory(result);
            }
            if (targetBlockEntity != null) {
                targetBlockEntity.setChanged();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.getChunkSource().blockChanged(targetPos);
                }
            }
            return fluidStack.copyWithAmount(requiredAmount);
        }
        return FluidStack.EMPTY;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<FluidInterfaceBlockEntity> getBlockEntityClass() {
        return FluidInterfaceBlockEntity.class;
    }

    public BlockEntityType<? extends FluidInterfaceBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CFBlockEntities.FLUID_INTERFACE.get();
    }

    private static class WaterloggedBlockFluidHandler
    implements IFluidHandler {
        private static final FluidStack WATER = new FluidStack((Fluid)Fluids.WATER, 1000);

        private WaterloggedBlockFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return WATER.copy();
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == Fluids.WATER) {
                return new FluidStack((Fluid)Fluids.WATER, Math.min(resource.getAmount(), 1000));
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return new FluidStack((Fluid)Fluids.WATER, Math.min(maxDrain, 1000));
        }
    }
}

