/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid.block.CopperTap;

import com.adonis.fluid.block.CopperTap.CopperTapBlockEntity;
import com.adonis.fluid.registry.CFBlockEntities;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.block.IBE;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CopperTapBlock
extends HorizontalDirectionalBlock
implements IBE<CopperTapBlockEntity>,
IWrenchable {
    public static final MapCodec<CopperTapBlock> CODEC = CopperTapBlock.simpleCodec(CopperTapBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape NORTH_OUTLET = Block.box((double)3.0, (double)3.0, (double)15.0, (double)13.0, (double)12.9, (double)16.0);
    private static final VoxelShape NORTH_PIPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)15.0);
    private static final VoxelShape NORTH_DROP = Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape NORTH_BASE = Block.box((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)13.0);
    private static final VoxelShape NORTH_VALVE_TOP = Block.box((double)5.0, (double)13.0, (double)9.0, (double)11.0, (double)14.0, (double)15.0);
    private static final VoxelShape NORTH_VALVE_HANDLE = Block.box((double)7.0, (double)11.0, (double)11.0, (double)9.0, (double)13.0, (double)13.0);
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)NORTH_OUTLET, (VoxelShape[])new VoxelShape[]{NORTH_PIPE, NORTH_DROP, NORTH_BASE, NORTH_VALVE_TOP, NORTH_VALVE_HANDLE});
    private static final VoxelShape SOUTH_OUTLET = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)12.9, (double)1.0);
    private static final VoxelShape SOUTH_PIPE = Block.box((double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SOUTH_DROP = Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape SOUTH_BASE = Block.box((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)5.0);
    private static final VoxelShape SOUTH_VALVE_TOP = Block.box((double)5.0, (double)13.0, (double)1.0, (double)11.0, (double)14.0, (double)7.0);
    private static final VoxelShape SOUTH_VALVE_HANDLE = Block.box((double)7.0, (double)11.0, (double)3.0, (double)9.0, (double)13.0, (double)5.0);
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)SOUTH_OUTLET, (VoxelShape[])new VoxelShape[]{SOUTH_PIPE, SOUTH_DROP, SOUTH_BASE, SOUTH_VALVE_TOP, SOUTH_VALVE_HANDLE});
    private static final VoxelShape EAST_OUTLET = Block.box((double)0.0, (double)3.0, (double)3.0, (double)1.0, (double)12.9, (double)13.0);
    private static final VoxelShape EAST_PIPE = Block.box((double)1.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape EAST_DROP = Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape EAST_BASE = Block.box((double)3.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    private static final VoxelShape EAST_VALVE_TOP = Block.box((double)1.0, (double)13.0, (double)5.0, (double)7.0, (double)14.0, (double)11.0);
    private static final VoxelShape EAST_VALVE_HANDLE = Block.box((double)3.0, (double)11.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0);
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)EAST_OUTLET, (VoxelShape[])new VoxelShape[]{EAST_PIPE, EAST_DROP, EAST_BASE, EAST_VALVE_TOP, EAST_VALVE_HANDLE});
    private static final VoxelShape WEST_OUTLET = Block.box((double)15.0, (double)3.0, (double)3.0, (double)16.0, (double)12.9, (double)13.0);
    private static final VoxelShape WEST_PIPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)15.0, (double)10.0, (double)10.0);
    private static final VoxelShape WEST_DROP = Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape WEST_BASE = Block.box((double)11.0, (double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0);
    private static final VoxelShape WEST_VALVE_TOP = Block.box((double)9.0, (double)13.0, (double)5.0, (double)15.0, (double)14.0, (double)11.0);
    private static final VoxelShape WEST_VALVE_HANDLE = Block.box((double)11.0, (double)11.0, (double)7.0, (double)13.0, (double)13.0, (double)9.0);
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)WEST_OUTLET, (VoxelShape[])new VoxelShape[]{WEST_PIPE, WEST_DROP, WEST_BASE, WEST_VALVE_TOP, WEST_VALVE_HANDLE});

    public CopperTapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, POWERED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, context);
    }

    private boolean isCopperGrate(BlockState state) {
        Block block = state.getBlock();
        return block == Blocks.COPPER_GRATE || block == Blocks.EXPOSED_COPPER_GRATE || block == Blocks.WEATHERED_COPPER_GRATE || block == Blocks.OXIDIZED_COPPER_GRATE || block == Blocks.WAXED_COPPER_GRATE || block == Blocks.WAXED_EXPOSED_COPPER_GRATE || block == Blocks.WAXED_WEATHERED_COPPER_GRATE || block == Blocks.WAXED_OXIDIZED_COPPER_GRATE;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos belowPos;
        BlockEntity belowEntity;
        UseOnContext wrenchContext;
        InteractionResult result;
        if (stack.getItem() instanceof WrenchItem && (result = this.onWrenched(state, wrenchContext = new UseOnContext(level, player, hand, stack, hitResult))) != InteractionResult.PASS) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.3f, 2.0f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (!stack.isEmpty() && GenericItemFilling.canItemBeFilled((Level)level, (ItemStack)stack) && !(stack.getItem() instanceof BucketItem) && (belowEntity = level.getBlockEntity(belowPos = pos.below())) != null && this.isDepot(belowEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            this.toggleTap(state, level, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    private boolean hasFluidCapability(Level level, BlockPos pos, Direction fromDirection) {
        BlockState blockState = level.getBlockState(pos);
        if (blockState.is(BlockTags.LEAVES) || this.isCopperGrate(blockState)) {
            return true;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity == null) {
            return false;
        }
        IFluidHandler capability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)fromDirection);
        if (capability != null && capability.getTanks() > 0) {
            return true;
        }
        capability = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
        return capability != null && capability.getTanks() > 0;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection().getOpposite();
        BlockPos blockpos = context.getClickedPos();
        BlockPos attachedPos = blockpos.relative(direction.getOpposite());
        Level level = context.getLevel();
        if (this.hasFluidCapability(level, attachedPos, direction)) {
            boolean powered = level.hasNeighborSignal(blockpos);
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered));
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos testPos = blockpos.relative(dir.getOpposite());
            if (!this.hasFluidCapability(level, testPos, dir)) continue;
            boolean powered = level.hasNeighborSignal(blockpos);
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered));
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos attachedPos = pos.relative(direction.getOpposite());
        BlockState attachedState = level.getBlockState(attachedPos);
        if (attachedState.is(BlockTags.LEAVES) || this.isCopperGrate(attachedState)) {
            return true;
        }
        if (level instanceof Level) {
            Level actualLevel = (Level)level;
            return this.hasFluidCapability(actualLevel, attachedPos, direction);
        }
        return false;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide) {
            BlockEntity be;
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockPos attachedPos = pos.relative(facing.getOpposite());
            if (fromPos.equals((Object)attachedPos) && !this.canSurvive(state, (LevelReader)level, pos)) {
                level.destroyBlock(pos, true);
                return;
            }
            if (!level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
                level.scheduleTick(pos, (Block)this, 1);
            }
            if (fromPos.equals((Object)pos.below()) && ((Boolean)state.getValue((Property)OPEN)).booleanValue() && (be = level.getBlockEntity(pos)) instanceof CopperTapBlockEntity) {
                CopperTapBlockEntity tapBE = (CopperTapBlockEntity)be;
                tapBE.onTargetChanged();
            }
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        boolean currentlyPowered;
        boolean previouslyPowered = (Boolean)state.getValue((Property)POWERED);
        if (previouslyPowered != (currentlyPowered = worldIn.hasNeighborSignal(pos))) {
            BlockState newState = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(currentlyPowered));
            if (currentlyPowered) {
                if (!((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    newState = (BlockState)newState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true));
                    worldIn.playSound(null, pos, SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            } else if (((Boolean)state.getValue((Property)OPEN)).booleanValue() && previouslyPowered) {
                newState = (BlockState)newState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
                worldIn.playSound(null, pos, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            worldIn.setBlock(pos, newState, 2);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.getLevel();
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            if (!level.isClientSide) {
                level.playSound(null, context.getClickedPos(), SoundEvents.IRON_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.3f, 2.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.isClientSide) {
            this.toggleTap(state, level, context.getClickedPos());
        }
        return InteractionResult.SUCCESS;
    }

    private void toggleTap(BlockState state, Level level, BlockPos pos) {
        boolean isOpen = (Boolean)state.getValue((Property)OPEN);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!isOpen)));
        level.playSound(null, pos, isOpen ? SoundEvents.IRON_TRAPDOOR_CLOSE : SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private boolean isDepot(BlockEntity entity) {
        return entity.getClass().getSimpleName().toLowerCase().contains("depot");
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<CopperTapBlockEntity> getBlockEntityClass() {
        return CopperTapBlockEntity.class;
    }

    public BlockEntityType<? extends CopperTapBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CFBlockEntities.COPPER_TAP.get();
    }
}

