/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.fluid;

import com.adonis.fluid.config.CFStressConfig;
import com.adonis.fluid.registry.CFBlockEntities;
import com.adonis.fluid.registry.CFBlocks;
import com.adonis.fluid.registry.CFCreativeTab;
import com.adonis.fluid.registry.CFItems;
import com.adonis.fluid.registry.CFPartialModels;
import com.adonis.fluid.registry.CFRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import java.util.Random;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@Mod(value="fluid")
public class CreateFluid {
    public static final String MOD_ID = "fluid";
    public static final String NAME = "Create Fluid";
    public static final Random RANDOM = new Random();
    public static final CFRegistrate REGISTRATE = CFRegistrate.create("fluid").setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    public static final CFStressConfig STRESS_CONFIG = new CFStressConfig("fluid");
    private static ModConfigSpec stressConfigSpec;

    public CreateFluid(IEventBus modEventBus, ModContainer modContainer) {
        REGISTRATE.registerEventListeners(modEventBus);
        CFBlocks.register();
        CFBlockEntities.register();
        CFBlockEntities.registerToEventBus(modEventBus);
        CFItems.register();
        CFCreativeTab.register(modEventBus);
        ModConfigSpec.Builder stressBuilder = new ModConfigSpec.Builder();
        STRESS_CONFIG.registerAll(stressBuilder);
        stressConfigSpec = stressBuilder.build();
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)stressConfigSpec, STRESS_CONFIG.getName() + ".toml");
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::onModConfigEvent);
        modEventBus.register(CFBlockEntities.class);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CFPartialModels.init());
    }

    private void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (stressConfigSpec == null || config.getSpec() == stressConfigSpec) {
            // empty if block
        }
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

