/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.infrastructure.data;

import com.oierbravo.create_mechanical_spawner.ModConstants;
import com.oierbravo.create_mechanical_spawner.registrate.ModFluids;
import com.oierbravo.mechanicals.foundation.data.AbstractCreateRecipeGen;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class CreateMixingRecipeGen
extends AbstractCreateRecipeGen {
    public CreateMixingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, ModConstants::asResource);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("random_legacy", (BaseFlowingFluid)ModFluids.RANDOM.get(), 250).require(Fluids.WATER, 250)).require(Tags.Items.RODS_BLAZE)).require(Tags.Items.ENDER_PEARLS)).requiresHeat(HeatCondition.HEATED)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("blaze", (BaseFlowingFluid)ModFluids.BLAZE.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.RODS_BLAZE)).requiresHeat(HeatCondition.HEATED)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("creeper", (BaseFlowingFluid)ModFluids.CREEPER.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.GUNPOWDER)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("drowned", (BaseFlowingFluid)ModFluids.DROWNED.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.ROTTEN_FLESH)).require(Fluids.WATER, 100)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("enderman", (BaseFlowingFluid)ModFluids.ENDERMAN.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.ENDER_PEARLS)).requiresHeat(HeatCondition.HEATED)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("evoker", (BaseFlowingFluid)ModFluids.EVOKER.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.GEMS_EMERALD)).require((ItemLike)Items.BOOK)).requiresHeat(HeatCondition.SUPERHEATED)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("ghast", (BaseFlowingFluid)ModFluids.GHAST.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.GHAST_TEAR)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("magma_cube", (BaseFlowingFluid)ModFluids.MAGMA_CUBE.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.MAGMA_CREAM)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("pigling", (BaseFlowingFluid)ModFluids.PIGLING.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.INGOTS_GOLD)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("skeleton", (BaseFlowingFluid)ModFluids.SKELETON.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.BONES)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("slime", (BaseFlowingFluid)ModFluids.SLIME.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.SLIMEBALLS)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("spider", (BaseFlowingFluid)ModFluids.SPIDER.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.SPIDER_EYE)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("witch", (BaseFlowingFluid)ModFluids.WITCH.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.GLASS_BOTTLE)).require(Tags.Items.DUSTS_REDSTONE)).require(Tags.Items.DUSTS_GLOWSTONE)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("wither_skeleton", (BaseFlowingFluid)ModFluids.WITHER_SKELETON.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.COAL)).require(Tags.Items.BONES)).requiresHeat(HeatCondition.SUPERHEATED)).duration(500)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("zombie", (BaseFlowingFluid)ModFluids.ZOMBIE.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.ROTTEN_FLESH)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("bat", (BaseFlowingFluid)ModFluids.BAT.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.FEATHERS)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("bee", (BaseFlowingFluid)ModFluids.BEE.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.HONEYCOMB)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("cow", (BaseFlowingFluid)ModFluids.COW.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.LEATHER)).require(Tags.Items.CROPS_WHEAT)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("chicken", (BaseFlowingFluid)ModFluids.CHICKEN.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.SEEDS_WHEAT)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("fox", (BaseFlowingFluid)ModFluids.FOX.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.SWEET_BERRIES)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("horse", (BaseFlowingFluid)ModFluids.HORSE.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.LEATHER)).require((ItemLike)Items.LEAD)).require((ItemLike)Items.APPLE)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("panda", (BaseFlowingFluid)ModFluids.PANDA.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Blocks.SNOW_BLOCK)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("parrot", (BaseFlowingFluid)ModFluids.PARROT.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.COOKIE)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("pig", (BaseFlowingFluid)ModFluids.PIG.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.PORKCHOP)).require((ItemLike)Items.CARROT)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("rabbit", (BaseFlowingFluid)ModFluids.RABBIT.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((ItemLike)Items.CARROT)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("villager", (BaseFlowingFluid)ModFluids.VILLAGER.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.GEMS_EMERALD)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("wolf", (BaseFlowingFluid)ModFluids.WOLF.get(), 250).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require(Tags.Items.BONES)).require((ItemLike)Items.PORKCHOP)).build(recipeOutput);
        ((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createSpawnFluid("wither", (BaseFlowingFluid)ModFluids.WITHER.get(), 100).require((FlowingFluid)ModFluids.RANDOM.get(), 100)).require((FlowingFluid)ModFluids.WITHER_SKELETON.get(), 100)).require((ItemLike)Items.WITHER_SKELETON_SKULL)).requiresHeat(HeatCondition.SUPERHEATED)).duration(700)).build(recipeOutput);
    }

    protected StandardProcessingRecipe.Builder<MixingRecipe> createSpawnFluid(String id, BaseFlowingFluid flowingFluid, int pAmount) {
        return (StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)this.createMixing("spawn_fluid_" + id).duration(250)).output(new FluidStack(flowingFluid.getSource(), pAmount));
    }

    public String getName() {
        return "Mechanical Spawner's mixer recipes.";
    }
}

