/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components.recipe;

import com.oierbravo.create_mechanical_spawner.ModConstants;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class SpawnerRecipeOutput {
    @Nullable
    private ResourceKey<EntityType<?>> mob;
    public static String RANDOM_KEY = "random";
    public static ResourceLocation RANDOM_RESOURCE_LOCATION = ModConstants.asResource(RANDOM_KEY);
    public static final SpawnerRecipeOutput EMPTY = new SpawnerRecipeOutput();

    SpawnerRecipeOutput(ResourceKey<EntityType<?>> mobEntity) {
        this.mob = mobEntity;
    }

    public SpawnerRecipeOutput() {
        this.mob = null;
    }

    public static SpawnerRecipeOutput of(EntityType<?> mobEntity) {
        return new SpawnerRecipeOutput(mobEntity.builtInRegistryHolder().key());
    }

    public static SpawnerRecipeOutput of(String id) {
        return SpawnerRecipeOutput.of(ResourceLocation.parse((String)id));
    }

    public static SpawnerRecipeOutput of(ResourceLocation resourceLocation) {
        if (resourceLocation.compareTo(RANDOM_RESOURCE_LOCATION) == 0) {
            return EMPTY;
        }
        return SpawnerRecipeOutput.of((EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation));
    }

    public ResourceKey<EntityType<?>> getMob() {
        return this.mob;
    }
}

