/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileMd5Placeholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public FileMd5Placeholder() {
        super("file_md5");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String filePath = dps.values.get("path");
        if (filePath == null || filePath.isEmpty()) {
            LOGGER.warn("[FANCYMENU] File MD5 placeholder: No path provided");
            return "";
        }
        if (filePath.startsWith("http://") || filePath.startsWith("https://")) {
            LOGGER.warn("[FANCYMENU] File MD5 placeholder: URLs are not supported, only local files");
            return "";
        }
        try {
            Path path;
            filePath = DotMinecraftUtils.resolveMinecraftPath(filePath);
            if (!DotMinecraftUtils.isInsideMinecraftDirectory(filePath)) {
                filePath = ResourceSource.of(filePath).getSourceWithoutPrefix();
            }
            if (!Files.exists(path = Paths.get(filePath, new String[0]), new LinkOption[0])) {
                LOGGER.warn("[FANCYMENU] File MD5 placeholder: File not found: " + filePath);
                return "";
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                LOGGER.warn("[FANCYMENU] File MD5 placeholder: Path is not a regular file: " + filePath);
                return "";
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (FileInputStream is = new FileInputStream(path.toFile());){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = ((InputStream)is).read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
            }
            byte[] digest = md.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : digest) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] File MD5 placeholder: Failed to calculate MD5 hash for: " + filePath, (Throwable)e);
            return "";
        }
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("path");
        return l;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.file_md5", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.file_md5.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("path", "/config/fancymenu/config.txt");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

