/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnBlockPlacedListener
extends AbstractListener {
    @Nullable
    private BlockPos lastBlockPos;
    @Nullable
    private String cachedBlockKey;

    public OnBlockPlacedListener() {
        super("block_placed");
    }

    public void onBlockPlaced(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        this.lastBlockPos = blockPos.immutable();
        ResourceLocation blockKeyLocation = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
        this.cachedBlockKey = blockKeyLocation != null ? blockKeyLocation.toString() : null;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("block_key", () -> this.cachedBlockKey != null ? this.cachedBlockKey : "ERROR"));
        list.add(new AbstractListener.CustomVariable("block_pos_x", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.getX()) : "0"));
        list.add(new AbstractListener.CustomVariable("block_pos_y", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.getY()) : "0"));
        list.add(new AbstractListener.CustomVariable("block_pos_z", () -> this.lastBlockPos != null ? Integer.toString(this.lastBlockPos.getZ()) : "0"));
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"fancymenu.listeners.on_block_placed");
    }

    @Override
    @NotNull
    public List<Component> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_block_placed.desc", new String[0]));
    }
}

