/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.neoforge.blocks;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.List;
import net.createcobblestone.neoforge.CreateCobblestoneNeoForge;
import net.createcobblestone.neoforge.data.GeneratorType;
import net.createcobblestone.neoforge.index.BlockEntities;
import net.createcobblestone.neoforge.index.Config;
import net.createcobblestone.neoforge.utils.CreateCobblestoneLang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class MechanicalGeneratorBlockEntity
extends KineticBlockEntity
implements Container {
    final NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final int size = 1;
    private double available = 0.0;
    public GeneratorType type = GeneratorType.NONE;

    public MechanicalGeneratorBlockEntity(BlockEntityType<? extends MechanicalGeneratorBlockEntity> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.type.writeToCompoundTag(compound);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        try {
            this.updateType(GeneratorType.fromCompoundTag(compound));
        }
        catch (IllegalArgumentException e) {
            CreateCobblestoneNeoForge.LOGGER.error("Invalid generator type \"{}\", setting type to NONE", (Object)GeneratorType.fromCompoundTag(compound).getId());
            this.type = GeneratorType.NONE;
            this.setChanged();
        }
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack = ContainerHelper.removeItem(this.items, (int)index, (int)count);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }

    public void tick() {
        Block generatorBlock;
        super.tick();
        try {
            generatorBlock = this.type.getBlock();
            if (!Config.common().isEnabled(this.type)) {
                this.updateType(GeneratorType.NONE);
                return;
            }
        }
        catch (NullPointerException e) {
            if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
                CreateCobblestoneNeoForge.LOGGER.error("Tried accessing generator block before world was loaded");
            }
            return;
        }
        if (generatorBlock != Blocks.AIR) {
            if (!this.type.isLoaded()) {
                this.updateType(GeneratorType.NONE);
                return;
            }
            if (this.available < (double)this.type.getStorage()) {
                this.available = Math.min(this.available + (double)(Math.abs(this.getSpeed() * this.type.getOutputPerSecondPerRpm()) / 20.0f), (double)this.type.getStorage());
            }
            int current = ((ItemStack)this.items.getFirst()).getCount();
            int added = (int)this.available;
            this.available -= (double)added;
            this.items.set(0, (Object)new ItemStack((ItemLike)generatorBlock, Math.min(current + added, this.type.getStorage())));
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)this.type.getGeneratorStress();
        return impact;
    }

    public void updateType(GeneratorType newType) {
        if (newType == null) {
            if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
                CreateCobblestoneNeoForge.LOGGER.error("Attempted to update generator type to null");
            }
            return;
        }
        if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
            CreateCobblestoneNeoForge.LOGGER.info("Trying to update generator type from \"{}\" to \"{}\"", (Object)this.type.getId(), (Object)newType.getId());
        }
        if (!Config.common().isEnabled(newType)) {
            if (!Config.common().isEnabled(this.type)) {
                newType = GeneratorType.NONE;
            } else {
                CreateCobblestoneNeoForge.LOGGER.error("Disabled generator type \"{}\", not changing old generator type. ({})", (Object)newType.getId(), (Object)this.type.getId());
                return;
            }
        }
        if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
            CreateCobblestoneNeoForge.LOGGER.info("Changing generator type from \"{}\" to \"{}\"", (Object)this.type.getId(), (Object)newType.getId());
        }
        this.type = newType;
        this.available = 0.0;
        this.items.clear();
        this.setChanged();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntities.MECHANICAL_GENERATOR.get(), (be, side) -> new InvWrapper((Container)be));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (!this.type.equals(GeneratorType.NONE)) {
            Item generatedItem = this.type.getItem();
            CreateCobblestoneLang.translate("gui.goggles.generators.itemprefix", generatedItem.getName(generatedItem.getDefaultInstance())).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        return added;
    }
}

