/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client.tooltip;

import ky.someone.mods.gag.util.tooltip.ItemTooltipComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public record ItemClientTooltip(ItemTooltipComponent data) implements ClientTooltipComponent
{
    public int getHeight() {
        return 18;
    }

    public int getWidth(Font font) {
        return 18;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        ItemStack stack = this.data.stack();
        if (!stack.isEmpty()) {
            graphics.renderItem(stack, x + 1, y + 1);
            graphics.pose().pushPose();
            Component text = this.data.customText();
            if (text == null && this.data().showCount() && stack.getCount() != 1) {
                text = Component.literal((String)String.valueOf(stack.getCount()));
            }
            if (text != null) {
                graphics.pose().translate(0.0f, 0.0f, 200.0f);
                graphics.drawString(font, text, x + 19 - 2 - font.width((FormattedText)text), y + 6 + 3, 0xFFFFFF, true);
            }
            graphics.pose().popPose();
        }
    }
}

