/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.client.tooltip;

import java.util.List;
import ky.someone.mods.gag.client.tooltip.ClientTooltipBuilder;
import ky.someone.mods.gag.util.VerticalAlignment;
import ky.someone.mods.gag.util.tooltip.HStackTooltipComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public record HStackClientTooltip(List<ClientTooltipComponent> components, int padding, VerticalAlignment align) implements ClientTooltipComponent
{
    public static HStackClientTooltip of(HStackTooltipComponent data) {
        ClientTooltipBuilder sink = new ClientTooltipBuilder();
        data.build(sink);
        return new HStackClientTooltip(sink.build(), data.padding, data.alignment);
    }

    public int getHeight() {
        int height = 0;
        for (ClientTooltipComponent component : this.components) {
            int h = component.getHeight();
            if (h <= height) continue;
            height = h;
        }
        return height;
    }

    public int getWidth(Font font) {
        int sum = 0;
        for (ClientTooltipComponent component : this.components) {
            int width = component.getWidth(font);
            sum += width;
        }
        return sum + (this.components.size() - 1) * this.padding;
    }

    public void renderText(Font font, int x, int y, Matrix4f pose, MultiBufferSource.BufferSource bufferSource) {
        int dx = 0;
        int h = this.getHeight();
        for (ClientTooltipComponent component : this.components) {
            int dy = this.align.yOffset(component.getHeight(), h);
            component.renderText(font, x + dx, y + dy, pose, bufferSource);
            dx += component.getWidth(font) + this.padding;
        }
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        int dx = 0;
        int h = this.getHeight();
        for (ClientTooltipComponent component : this.components) {
            int dy = this.align.yOffset(component.getHeight(), h);
            component.renderImage(font, x + dx, y + dy, graphics);
            dx += component.getWidth(font) + this.padding;
        }
    }
}

