/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.serialization.MapCodec;
import com.mrcrayfish.goblintraders.Constants;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.BaseTrade;
import com.mrcrayfish.goblintraders.trades.type.BasicTrade;
import com.mrcrayfish.goblintraders.trades.type.TreasureMapTrade;
import it.unimi.dsi.fastutil.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class TradeManager
implements PreparableReloadListener {
    public static final String RESOURCE_DIR = "goblin_trades";
    private static final int FILE_TYPE_LENGTH_VALUE = ".json".length();
    private static final Gson GSON = new GsonBuilder().create();
    private static TradeManager instance;
    private final List<EntityType<?>> traders = new ArrayList();
    private final Map<ResourceLocation, MapCodec<? extends BaseTrade>> codecs = new HashMap<ResourceLocation, MapCodec<? extends BaseTrade>>();
    private Map<EntityType<?>, EntityTrades> entityToTrades = new HashMap();

    public static TradeManager instance() {
        if (instance == null) {
            instance = new TradeManager();
        }
        return instance;
    }

    public TradeManager() {
        this.registerTradeCodec(BasicTrade.ID, BasicTrade.CODEC);
        this.registerTradeCodec(TreasureMapTrade.ID, TreasureMapTrade.CODEC);
    }

    public void registerTrader(EntityType<? extends TraderCreatureEntity> type) {
        if (!this.traders.contains(type)) {
            this.traders.add(type);
        }
    }

    @Nullable
    public EntityTrades getTrades(EntityType<? extends TraderCreatureEntity> type) {
        return this.entityToTrades.get(type);
    }

    public void registerTradeCodec(ResourceLocation id, MapCodec<? extends BaseTrade> codec) {
        this.codecs.putIfAbsent(id, codec);
    }

    @Nullable
    public MapCodec<? extends BaseTrade> getTradeCodec(ResourceLocation id) {
        return this.codecs.get(id);
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        List<CompletableFuture> list = this.traders.stream().map(type -> CompletableFuture.supplyAsync(() -> {
            String folder = String.format("%s/%s", RESOURCE_DIR, EntityType.getKey((EntityType)type).getPath());
            ArrayList resources = new ArrayList(manager.listResources(folder, fileName -> fileName.getPath().endsWith(".json")).keySet());
            resources.sort((r1, r2) -> {
                if (r1.getNamespace().equals(r2.getNamespace())) {
                    return 0;
                }
                return r2.getNamespace().equals("goblintraders") ? 1 : -1;
            });
            EnumMap tradeResources = new EnumMap(TradeRarity.class);
            Arrays.stream(TradeRarity.values()).forEach(rarity -> tradeResources.put((TradeRarity)((Object)((Object)((Object)rarity))), new LinkedHashSet()));
            resources.forEach(resource -> {
                String path = resource.getPath().substring(0, resource.getPath().length() - FILE_TYPE_LENGTH_VALUE);
                String[] splitPath = path.split("/");
                if (splitPath.length != 3) {
                    return;
                }
                Arrays.stream(TradeRarity.values()).forEach(rarity -> {
                    if (rarity.getKey().equals(splitPath[2])) {
                        ((LinkedHashSet)tradeResources.get(rarity)).add(resource);
                    }
                });
            });
            EntityTrades.Builder builder = EntityTrades.builder();
            Arrays.stream(TradeRarity.values()).forEach(rarity -> this.deserializeTrades(manager, builder, (TradeRarity)((Object)((Object)((Object)rarity))), (LinkedHashSet)tradeResources.get(rarity)));
            return Pair.of((Object)type, (Object)builder.build());
        }, backgroundExecutor)).toList();
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(obj -> {
            this.entityToTrades = (Map)list.stream().map(CompletableFuture::join).collect(ImmutableMap.toImmutableMap(Pair::left, Pair::right));
        }, gameExecutor);
    }

    private void deserializeTrades(ResourceManager manager, EntityTrades.Builder builder, TradeRarity rarity, LinkedHashSet<ResourceLocation> resources) {
        for (ResourceLocation resourceLocation : resources) {
            manager.getResource(resourceLocation).ifPresent(resource -> {
                try (BufferedReader reader = resource.openAsReader();){
                    JsonObject object = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    builder.deserialize(rarity, object);
                }
                catch (IOException e) {
                    Constants.LOG.error("Failed to load trade file: " + String.valueOf(resourceLocation));
                }
            });
        }
    }
}

