/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.TrailDescriptor;
import immersive_aircraft.item.upgrade.VehicleStat;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class AirshipEntity
extends Rotorcraft {
    public AirshipEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world, true);
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 50.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public Item asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    protected double getDefaultGravity() {
        return this.wasTouchingWater ? (double)-0.04f : (double)(1.0f - this.getEnginePower()) * super.getDefaultGravity();
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.canTurnOnEngine((Entity)this.getControllingPassenger())) {
            this.setEngineTarget(1.0f);
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(this.getEnginePower() * this.getProperties().get(VehicleStat.VERTICAL_SPEED) * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3f direction = this.getForwardDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.getProperties().get(VehicleStat.ENGINE_SPEED)) * this.pressingInterpolatedZ.getSmooth();
        Vector3f f = direction.mul(thrust);
        this.setDeltaMovement(this.getDeltaMovement().add((double)f.x, (double)f.y, (double)f.z));
    }

    @Override
    protected float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return Math.max(0.0f, Math.min(1.0f, (float)(this.getDeltaMovement().length() - (double)0.05f)));
    }

    @Override
    public void tick() {
        super.tick();
        float power = this.getEnginePower();
        if (this.level().isClientSide && this.isWithinParticleRange() && (double)power > 0.01) {
            Matrix4f transform = this.getVehicleTransform();
            if (this.tickCount % 2 == 0) {
                Vector4f p = this.transformPosition(transform, (this.random.nextFloat() - 0.5f) * 0.4f, 0.8f, -0.8f);
                Vec3 velocity = this.getDeltaMovement();
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)p.x, (double)p.y, (double)p.z, velocity.x, velocity.y, velocity.z);
            }
        }
    }

    @Override
    public double getZoom() {
        return 5.0;
    }

    @Override
    public float getPropellerSpeed() {
        return super.getPropellerSpeed() * (0.25f + Math.abs(this.pressingInterpolatedZ.get(0.0f)));
    }
}

