/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.intervals;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalScoreFunction;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalScorer;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalsSource;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.FilterMatchesIterator;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Matches;
import org.apache.lucene.ars_nouveau.search.MatchesUtils;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.ScorerSupplier;
import org.apache.lucene.ars_nouveau.search.Weight;

public final class IntervalQuery
extends Query {
    private final String field;
    private final IntervalsSource intervalsSource;
    private final IntervalScoreFunction scoreFunction;

    public IntervalQuery(String field, IntervalsSource intervalsSource) {
        this(field, intervalsSource, IntervalScoreFunction.saturationFunction(1.0f));
    }

    public IntervalQuery(String field, IntervalsSource intervalsSource, float pivot) {
        this(field, intervalsSource, IntervalScoreFunction.saturationFunction(pivot));
    }

    public IntervalQuery(String field, IntervalsSource intervalsSource, float pivot, float exp) {
        this(field, intervalsSource, IntervalScoreFunction.sigmoidFunction(pivot, exp));
    }

    private IntervalQuery(String field, IntervalsSource intervalsSource, IntervalScoreFunction scoreFunction) {
        Objects.requireNonNull(field, "null field aren't accepted");
        Objects.requireNonNull(intervalsSource, "null intervalsSource aren't accepted");
        Objects.requireNonNull(scoreFunction, "null searchStrategy aren't accepted");
        this.field = field;
        this.intervalsSource = intervalsSource;
        this.scoreFunction = scoreFunction;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field) {
        return (String)(!this.getField().equals(field) ? this.getField() + ":" : "") + this.intervalsSource.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new IntervalWeight(this, boost);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            this.intervalsSource.visit(this.field, visitor);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalQuery that = (IntervalQuery)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.intervalsSource, that.intervalsSource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.intervalsSource);
    }

    private class IntervalWeight
    extends Weight {
        final float boost;

        public IntervalWeight(Query query, float boost) {
            super(query);
            this.boost = boost;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            IntervalScorer scorer = (IntervalScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = scorer.freq();
                return IntervalQuery.this.scoreFunction.explain(IntervalQuery.this.toString(), this.boost, freq);
            }
            return Explanation.noMatch("no matching intervals", new Explanation[0]);
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            return MatchesUtils.forField(IntervalQuery.this.field, () -> {
                IntervalMatchesIterator mi = IntervalQuery.this.intervalsSource.matches(IntervalQuery.this.field, context, doc);
                if (mi == null) {
                    return null;
                }
                return new FilterMatchesIterator(mi){

                    @Override
                    public Query getQuery() {
                        return new IntervalQuery(IntervalQuery.this.field, IntervalQuery.this.intervalsSource);
                    }
                };
            });
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            IntervalIterator intervals = IntervalQuery.this.intervalsSource.intervals(IntervalQuery.this.field, context);
            if (intervals == null) {
                return null;
            }
            IntervalScorer scorer = new IntervalScorer(intervals, IntervalQuery.this.intervalsSource.minExtent(), this.boost, IntervalQuery.this.scoreFunction);
            return new Weight.DefaultScorerSupplier(scorer);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

