/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import java.util.Collection;
import org.apache.lucene.ars_nouveau.document.Field;
import org.apache.lucene.ars_nouveau.document.FieldType;
import org.apache.lucene.ars_nouveau.document.SortedSetDocValuesRangeQuery;
import org.apache.lucene.ars_nouveau.index.DocValuesSkipIndexType;
import org.apache.lucene.ars_nouveau.index.DocValuesType;
import org.apache.lucene.ars_nouveau.search.MultiTermQuery;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.TermInSetQuery;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class SortedDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();
    private static final FieldType INDEXED_TYPE;

    public static SortedDocValuesField indexedField(String name, BytesRef bytes) {
        return new SortedDocValuesField(name, bytes, INDEXED_TYPE);
    }

    public SortedDocValuesField(String name, BytesRef bytes) {
        this(name, bytes, TYPE);
    }

    private SortedDocValuesField(String name, BytesRef bytes, FieldType fieldType) {
        super(name, fieldType);
        this.fieldsData = bytes;
    }

    public static Query newSlowRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field, lowerValue, upperValue, lowerInclusive, upperInclusive);
    }

    public static Query newSlowExactQuery(String field, BytesRef value) {
        return SortedDocValuesField.newSlowRangeQuery(field, value, value, true, true);
    }

    public static Query newSlowSetQuery(String field, Collection<BytesRef> values) {
        return new TermInSetQuery(MultiTermQuery.DOC_VALUES_REWRITE, field, values);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED);
        TYPE.freeze();
        INDEXED_TYPE = new FieldType(TYPE);
        INDEXED_TYPE.setDocValuesSkipIndexType(DocValuesSkipIndexType.RANGE);
        INDEXED_TYPE.freeze();
    }
}

