/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.MobJar;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;

public class RitualMobCapture
extends AbstractRitual {
    @Override
    protected void tick() {
        Level world = this.getWorld();
        int radius = 3;
        if (world.isClientSide) {
            BlockPos pos = this.getPos();
            ParticleUtil.spawnRitualAreaEffect(this.getPos(), this.getWorld(), this.rand, this.getCenterColor(), radius);
        }
        if (!this.getWorld().isClientSide && world.getGameTime() % 60L == 0L) {
            boolean didWorkOnce = false;
            Level level = this.getWorld();
            BlockPos pos = this.getPos();
            block0: for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-radius, -radius, -radius), (BlockPos)pos.offset(radius, radius, radius))) {
                MobJarTile tile;
                if (!(level.getBlockState(blockPos).getBlock() instanceof MobJar) || (tile = (MobJarTile)level.getBlockEntity(blockPos)) == null || tile.getEntity() != null) continue;
                for (Entity e : level.getEntities((Entity)null, new AABB(tile.getBlockPos()).inflate(5.0), this::canJar)) {
                    ItemEntity item;
                    Raider raider;
                    for (Entity passenger : e.getPassengers()) {
                        passenger.stopRiding();
                    }
                    if (e instanceof Mob) {
                        Mob mob = (Mob)e;
                        if (((Mob)e).isLeashed() && e.shouldBeSaved() && mob.isLeashed()) {
                            mob.dropLeash(true, true);
                        }
                    }
                    if (e instanceof Raider && (raider = (Raider)e).hasActiveRaid()) {
                        raider.getCurrentRaid().removeFromRaid(raider, false);
                    }
                    if (e instanceof Villager) {
                        Villager villager = (Villager)e;
                        villager.releasePoi(MemoryModuleType.HOME);
                        villager.releasePoi(MemoryModuleType.JOB_SITE);
                        villager.releasePoi(MemoryModuleType.POTENTIAL_JOB_SITE);
                        villager.releasePoi(MemoryModuleType.MEETING_POINT);
                    }
                    if (!tile.setEntityData(e)) continue;
                    e.remove(Entity.RemovalReason.UNLOADED_TO_CHUNK);
                    EntityFlyingItem followProjectile = new EntityFlyingItem(level, e.position, Vec3.atCenterOf((Vec3i)tile.getBlockPos()), 100, 50, 100);
                    level.addFreshEntity((Entity)followProjectile);
                    ParticleUtil.spawnPoof((ServerLevel)level, e.getOnPos().above());
                    didWorkOnce = true;
                    if (e instanceof Starbuncle) {
                        Starbuncle starbuncle = (Starbuncle)e;
                        ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.SHRUNK_STARBY.get(), (ServerLevel)level, starbuncle.blockPosition(), 10);
                    }
                    if (e instanceof LightningBolt) {
                        LightningBolt bolt = (LightningBolt)e;
                        ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.CAUGHT_LIGHTNING.get(), (ServerLevel)level, bolt.blockPosition(), 10);
                    }
                    if (!(e instanceof ItemEntity) || (item = (ItemEntity)e).getItem().getItem() != Items.CLOCK) continue block0;
                    ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.TIME_IN_BOTTLE.get(), (ServerLevel)level, item.blockPosition(), 10);
                    continue block0;
                }
            }
            if (didWorkOnce) {
                this.setNeedsSource(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canJar(Entity e) {
        if (e.getType().is(EntityTags.JAR_WHITELIST)) {
            return true;
        }
        if (e.getType().is(EntityTags.JAR_BLACKLIST)) {
            return false;
        }
        if (e instanceof PartEntity) {
            return false;
        }
        if (!(e instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)e;
        if (e instanceof Player) return false;
        if (((LivingEntity)e).isDeadOrDying()) return false;
        return true;
    }

    @Override
    public int getSourceCost() {
        return 500;
    }

    @Override
    public String getLangDescription() {
        return "Captures a nearby entity and places it into any nearby placed Containment Jars. After the first capture, this ritual requires additional source to continue. Mobs and jars must be within 3 blocks of the brazier.";
    }

    @Override
    public String getLangName() {
        return "Containment";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.CONTAINMENT);
    }
}

