/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.client.jei.JEIArsNouveauPlugin;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ScryRitualRecipe;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ScryRitualRecipeCategory
implements IRecipeCategory<RecipeHolder<ScryRitualRecipe>> {
    public static final ResourceLocation SCRY_RITUAL = ArsNouveau.prefix(RitualLib.SCRYING);
    private final IDrawableAnimated arrow;
    public IDrawable background;
    public IDrawable icon;

    public ScryRitualRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(120, 24);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)RitualRegistry.getRitualItemMap().get(SCRY_RITUAL).asItem().getDefaultInstance());
        this.arrow = helper.createAnimatedRecipeArrow(40);
    }

    public RecipeType<RecipeHolder<ScryRitualRecipe>> getRecipeType() {
        return JEIArsNouveauPlugin.SCRY_RITUAL_RECIPE_TYPE.get();
    }

    public Component getTitle() {
        return Component.translatable((String)"ars_nouveau.scry_ritual_recipe");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(RecipeHolder<ScryRitualRecipe> recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics matrixStack, double mouseX, double mouseY) {
        this.background.draw(matrixStack, 0, 0);
        this.arrow.draw(matrixStack, 48, 5);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ScryRitualRecipe> recipeHolder, IFocusGroup focuses) {
        ScryRitualRecipe recipe = (ScryRitualRecipe)recipeHolder.value();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Holder blockHolder : BuiltInRegistries.BLOCK.getTagOrEmpty(recipe.highlight())) {
            items.add(((Block)blockHolder.value()).asItem().getDefaultInstance());
        }
        ItemStack[] stacks = items.toArray(new ItemStack[0]);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 4).addIngredients(Ingredient.of((ItemStack[])stacks));
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 4).addIngredients(Ingredient.of(recipe.augment()));
    }
}

