/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.mob_jar;

import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class JarBehavior<T extends Entity> {
    public void use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, MobJarTile tile) {
        T entity = this.entityFromJar(tile);
        if (entity.getType().is(EntityTags.INTERACT_JAR_BLACKLIST)) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack handItem = player.getItemInHand(handIn);
            InteractionResult result = handItem.getItem().interactLivingEntity(handItem, player, livingEntity, handIn);
            if (result != InteractionResult.PASS) {
                this.syncClient(tile);
                return;
            }
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.interact(player, handIn);
            this.syncClient(tile);
        }
    }

    public void tick(MobJarTile tile) {
    }

    public void syncClient(MobJarTile tile) {
        tile.updateBlock();
    }

    @NotNull
    public T entityFromJar(MobJarTile tile) {
        return (T)tile.getEntity();
    }

    public boolean isEntityBaby(Entity entity) {
        if (!(entity instanceof AgeableMob)) {
            return false;
        }
        AgeableMob ageableMob = (AgeableMob)entity;
        return ageableMob.isBaby();
    }

    public Vec3 scaleOffset(MobJarTile pBlockEntity) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public Vec3 translate(MobJarTile pBlockEntity) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean shouldUsePartialTicks(MobJarTile pBlockEntity) {
        return false;
    }

    public int lightLevel(MobJarTile pBlockEntity) {
        return 0;
    }

    public int getAnalogPower(MobJarTile tile) {
        return tile.getEntity() == null ? 0 : 15;
    }

    public void onRedstonePower(MobJarTile tile) {
        T entity = this.entityFromJar(tile);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.playAmbientSound();
        }
    }

    public boolean isPowered(MobJarTile tile) {
        return (Boolean)tile.getBlockState().getValue((Property)BlockStateProperties.POWERED);
    }

    public int getSignalPower(MobJarTile tile) {
        return 0;
    }

    public void getTooltip(MobJarTile tile, List<Component> tooltips) {
    }

    public static boolean insertOrCreateItem(MobJarTile tile, ItemStack stack) {
        Level level = tile.getLevel();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = tile.getBlockPos();
        InventoryManager inv = InventoryManager.fromTile(tile);
        ItemStack remaining = inv.insertStack(stack);
        if (!remaining.isEmpty()) {
            Vec3 center = pos.above().getCenter();
            ItemEntity item = new ItemEntity((Level)level2, center.x, center.y, center.z, remaining);
            item.setDefaultPickUpDelay();
            level2.addFreshEntity((Entity)item);
        }
        return true;
    }
}

