/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.handler;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.concurrent.SynchronizedConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.ParsingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeConfig;
import com.mrcrayfish.configured.network.ServerPlayHelper;
import com.mrcrayfish.configured.network.payload.SyncNeoForgeConfigPayload;
import com.mrcrayfish.configured.util.NeoForgeConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeServerPlayHandler {
    public static void handleSyncServerConfigMessage(Player sender, SyncNeoForgeConfigPayload payload) {
        if (!(sender instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)sender;
        Constants.LOG.debug("Received NeoForge server config sync from player: {}", (Object)sender.getName().getString());
        if (!ServerPlayHelper.canEditServerConfigs(player)) {
            return;
        }
        ModConfig modConfig = NeoForgeConfigHelper.getModConfig(payload.fileName());
        if (modConfig == null) {
            Constants.LOG.warn("{} tried to update a NeoForge config that doesn't exist!", (Object)player.getName().getString());
            player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (modConfig.getType() != ModConfig.Type.SERVER) {
            Constants.LOG.warn("{} tried to update a NeoForge config that isn't a server type", (Object)player.getName().getString());
            player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        NeoForgeConfig config = new NeoForgeConfig(modConfig);
        ActionResult permission = config.canPlayerEdit((Player)player);
        if (!permission.asBoolean()) {
            Constants.LOG.warn("{} tried to update the NeoForge config '{}' but didn't have permission", (Object)player.getName().getString(), (Object)modConfig.getFileName());
            player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.unauthorized_request"));
            return;
        }
        try {
            IConfigSpec iConfigSpec = modConfig.getSpec();
            if (iConfigSpec instanceof ModConfigSpec) {
                ModConfigSpec spec = (ModConfigSpec)iConfigSpec;
                SynchronizedConfig updatedConfig = new SynchronizedConfig((ConfigFormat)TomlFormat.instance(), LinkedHashMap::new);
                updatedConfig.bulkCommentedUpdate(view -> TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(payload.data()), (Config)view, ParsingMode.REPLACE));
                AtomicBoolean malformed = new AtomicBoolean();
                int result = spec.correct((CommentedConfig)updatedConfig, (action, path, incorrectValue, correctedValue) -> {
                    if (action == ConfigSpec.CorrectionAction.ADD || action == ConfigSpec.CorrectionAction.REMOVE) {
                        malformed.set(true);
                    } else if (action == ConfigSpec.CorrectionAction.REPLACE) {
                        Constants.LOG.warn("The value for path \"{}\" was originally \"{}\" but was corrected to \"{}\"", new Object[]{path, incorrectValue, correctedValue});
                    }
                });
                if (malformed.get()) {
                    Constants.LOG.warn("{} sent malformed config data when updating a NeoForge config: {}", (Object)player.getName().getString(), (Object)modConfig.getFileName());
                    player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.bad_config_packet"));
                    return;
                }
                if (result != 0) {
                    Constants.LOG.debug("Config data sent from {} needed to be corrected", (Object)player.getName().getString());
                }
                NeoForgeConfigHelper.setConfigData(modConfig, (CommentedConfig)updatedConfig);
            }
        }
        catch (ParsingException e) {
            Constants.LOG.warn("{} sent malformed config data to the server", (Object)player.getName().getString());
            player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.bad_config_packet"));
            ServerPlayHelper.sendMessageToOperators((Component)Component.translatable((String)"configured.chat.malformed_config_data", (Object[])new Object[]{player.getName(), Component.literal((String)modConfig.getFileName()).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.RED), player);
            return;
        }
        catch (Exception e) {
            Constants.LOG.warn("Failed to process config data sent by {}", (Object)player.getName().getString());
            player.connection.disconnect((Component)Component.translatable((String)"configured.multiplayer.disconnect.bad_config_packet"));
            ServerPlayHelper.sendMessageToOperators((Component)Component.translatable((String)"configured.chat.failed_config_update", (Object[])new Object[]{Component.literal((String)modConfig.getFileName()).withStyle(ChatFormatting.GRAY), player.getName()}).withStyle(ChatFormatting.RED), player);
            return;
        }
        Constants.LOG.debug("Successfully processed config update for '" + payload.fileName() + "'");
        ServerPlayHelper.sendMessageToOperators((Component)Component.translatable((String)"configured.chat.config_updated", (Object[])new Object[]{player.getName(), modConfig.getFileName()}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}), player);
        player.server.getPlayerList().getPlayers().forEach(player1 -> {
            if (!player1.equals((Object)player)) {
                player1.connection.disconnect((Component)Component.translatable((String)"configured.gui.neoforge.server_configs_updated"));
            }
        });
    }
}

