/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.neoforge;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.concurrent.SynchronizedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Suppliers;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.api.ActionResult;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.ExecutionContext;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.ClientSessionData;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeFolderEntry;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeListValue;
import com.mrcrayfish.configured.impl.neoforge.NeoForgeValue;
import com.mrcrayfish.configured.network.payload.SyncNeoForgeConfigPayload;
import com.mrcrayfish.configured.util.ConfigHelper;
import com.mrcrayfish.configured.util.NeoForgeConfigHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class NeoForgeConfig
implements IModConfig {
    protected static final EnumMap<ModConfig.Type, ConfigType> TYPE_RESOLVER = (EnumMap)Util.make(new EnumMap(ModConfig.Type.class), map -> {
        map.put(ModConfig.Type.CLIENT, ConfigType.CLIENT);
        map.put(ModConfig.Type.COMMON, ConfigType.UNIVERSAL);
        map.put(ModConfig.Type.SERVER, ConfigType.WORLD_SYNC);
        map.put(ModConfig.Type.STARTUP, ConfigType.UNIVERSAL);
    });
    protected final ModConfig config;
    protected final Supplier<List<ForgeValueEntry>> allConfigValues;

    public NeoForgeConfig(ModConfig config) {
        this.config = config;
        this.allConfigValues = Suppliers.memoize(() -> this.getAllConfigValues(config));
    }

    @Override
    public ActionResult update(IConfigEntry entry) {
        CommentedConfig origConfig = NeoForgeConfigHelper.getConfigData(this.config);
        if (origConfig == null) {
            Constants.LOG.error("Unable to update config '{}' as it is not loaded", (Object)this.config.getFileName());
            return ActionResult.fail((Component)Component.translatable((String)"configured.gui.update_error.unloaded"));
        }
        Set<IConfigValue<?>> changedValues = ConfigHelper.getChangedValues(entry);
        if (!changedValues.isEmpty()) {
            SynchronizedConfig newConfig = new SynchronizedConfig((ConfigFormat)TomlFormat.instance(), LinkedHashMap::new);
            changedValues.forEach(value -> {
                if (value instanceof NeoForgeValue) {
                    NeoForgeListValue forgeList;
                    List converted;
                    NeoForgeValue forge = (NeoForgeValue)value;
                    if (forge instanceof NeoForgeListValue && (converted = (forgeList = (NeoForgeListValue)forge).getConverted()) != null) {
                        newConfig.set(forge.configValue.getPath(), converted);
                        return;
                    }
                    newConfig.set(forge.configValue.getPath(), value.get());
                }
            });
            origConfig.putAll((UnmodifiableConfig)newConfig);
            NeoForgeConfigHelper.correctConfig(this.config, origConfig);
        }
        if (this.getType() == ConfigType.WORLD_SYNC && !ConfigHelper.isSingleplayer()) {
            if (!ConfigHelper.isPlayingGame()) {
                NeoForgeConfigHelper.saveConfig(this.config);
                NeoForgeConfigHelper.closeConfig(this.config);
            } else {
                this.syncToServer();
            }
        } else if (!changedValues.isEmpty()) {
            Constants.LOG.info("Saving config and sending reloading event for {}", (Object)this.config.getFileName());
            NeoForgeConfigHelper.resetConfigCache(this.config);
            NeoForgeConfigHelper.saveConfig(this.config);
        }
        return ActionResult.success();
    }

    @Override
    public IConfigEntry createRootEntry() {
        return new NeoForgeFolderEntry(((ModConfigSpec)this.config.getSpec()).getValues(), (ModConfigSpec)this.config.getSpec());
    }

    @Override
    public ConfigType getType() {
        return TYPE_RESOLVER.get(this.config.getType());
    }

    @Override
    public String getFileName() {
        return this.config.getFileName();
    }

    @Override
    public String getModId() {
        return this.config.getModId();
    }

    @Override
    public ActionResult loadWorldConfig(Path path) {
        if (this.config.getLoadedConfig() == null) {
            try {
                NeoForgeConfigHelper.openConfig(this.config, path);
                if (this.config.getLoadedConfig() != null) {
                    return ActionResult.success();
                }
                return ActionResult.fail();
            }
            catch (Exception e) {
                return ActionResult.fail((Component)Component.literal((String)e.getMessage()));
            }
        }
        return ActionResult.success();
    }

    @Override
    public void stopEditing(boolean updated) {
        if (this.config != null && this.getType() == ConfigType.WORLD_SYNC && !ConfigHelper.isPlayingGame()) {
            NeoForgeConfigHelper.closeConfig(this.config);
        }
    }

    @Override
    public boolean isChanged() {
        CommentedConfig data = NeoForgeConfigHelper.getConfigData(this.config);
        if (data == null) {
            return false;
        }
        return this.allConfigValues.get().stream().anyMatch(entry -> !Objects.equals(entry.value.get(), entry.spec.getDefault()));
    }

    @Override
    public Optional<Runnable> restoreDefaultsTask() {
        if (this.config.getType() == ModConfig.Type.SERVER && ConfigHelper.isPlayingOnRemoteServer()) {
            return Optional.empty();
        }
        return Optional.ofNullable(NeoForgeConfigHelper.getConfigData(this.config)).map(data -> () -> {
            CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)data);
            this.allConfigValues.get().forEach(entry -> newConfig.set(entry.value.getPath(), entry.spec.getDefault()));
            data.putAll((UnmodifiableConfig)newConfig);
            this.allConfigValues.get().forEach(pair -> pair.value.clearCache());
        });
    }

    @Override
    public ActionResult canPlayerEdit(@Nullable Player player) {
        ExecutionContext context = new ExecutionContext(player);
        if (context.isClient()) {
            return switch (this.config.getType()) {
                default -> throw new MatchException(null, null);
                case ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.STARTUP -> {
                    if (context.isMainMenu() || context.isLocalPlayer()) {
                        yield ActionResult.success();
                    }
                    yield ActionResult.fail();
                }
                case ModConfig.Type.SERVER -> {
                    if (context.isMainMenu() || context.isSingleplayer()) {
                        yield ActionResult.success();
                    }
                    if (context.isPlayingOnLan()) {
                        if (context.isIntegratedServerOwnedByPlayer()) {
                            yield ActionResult.fail((Component)Component.translatable((String)"configured.gui.no_editing_published_lan_server"));
                        }
                        yield ActionResult.fail((Component)Component.translatable((String)"configured.gui.lan_server"));
                    }
                    if (context.isPlayingOnRemoteServer()) {
                        if (context.isPlayerAnOperator() && context.isDeveloperPlayer()) {
                            yield ActionResult.success();
                        }
                        yield ActionResult.fail((Component)Component.translatable((String)"configured.gui.no_developer_status"));
                    }
                    yield ActionResult.fail();
                }
            };
        }
        if (context.isDedicatedServer()) {
            return switch (this.config.getType()) {
                default -> throw new MatchException(null, null);
                case ModConfig.Type.CLIENT, ModConfig.Type.COMMON, ModConfig.Type.STARTUP -> ActionResult.fail();
                case ModConfig.Type.SERVER -> context.isPlayerAnOperator() && context.isDeveloperPlayer() ? ActionResult.success() : ActionResult.fail();
            };
        }
        return ActionResult.fail();
    }

    @Override
    public ActionResult showSaveConfirmation(Player player) {
        ExecutionContext context = new ExecutionContext(player);
        if (context.isClient() && context.isPlayingOnRemoteServer() && this.config.getType() == ModConfig.Type.SERVER) {
            return ActionResult.success((Component)Component.translatable((String)"configured.gui.neoforge.players_kicked"));
        }
        return ActionResult.fail();
    }

    private void syncToServer() {
        if (this.config == null) {
            return;
        }
        CommentedConfig data = NeoForgeConfigHelper.getConfigData(this.config);
        if (data == null) {
            return;
        }
        if (ConfigHelper.isSingleplayer() || ConfigHelper.isPlayingLan()) {
            return;
        }
        if (!ConfigHelper.isPlayingGame()) {
            return;
        }
        if (!ConfigHelper.isConfiguredInstalledOnServer()) {
            return;
        }
        if (this.getType() != ConfigType.WORLD_SYNC) {
            return;
        }
        Player player = ConfigHelper.getClientPlayer();
        if (!ConfigHelper.isOperator(player) || !ClientSessionData.isDeveloper()) {
            return;
        }
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            TomlFormat.instance().createWriter().write((UnmodifiableConfig)data, (OutputStream)stream);
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncNeoForgeConfigPayload(this.config.getFileName(), stream.toByteArray()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            stream.close();
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to close byte stream when sending config to server");
        }
    }

    protected List<ForgeValueEntry> getAllConfigValues(ModConfig config) {
        return NeoForgeConfigHelper.gatherAllConfigValues(config).stream().map(pair -> new ForgeValueEntry((ModConfigSpec.ConfigValue)pair.getLeft(), (ModConfigSpec.ValueSpec)pair.getRight())).toList();
    }

    protected record ForgeValueEntry(ModConfigSpec.ConfigValue<?> value, ModConfigSpec.ValueSpec spec) {
    }
}

