/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Optional;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.HolderRef;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.Nullable;

public class OptHolderRef<T>
extends HolderRef<T> {
    public static <A> OptHolderRef<A> of(ResourceLocation location, ResourceKey<Registry<A>> registry) {
        return new OptHolderRef<A>(registry, ResourceKey.create(registry, (ResourceLocation)location));
    }

    public static <A> OptHolderRef<A> of(ResourceKey<A> key) {
        return new OptHolderRef<A>(ResourceKey.createRegistryKey((ResourceLocation)key.registry()), key);
    }

    protected OptHolderRef(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
        super(registryKey, key);
    }

    public boolean isPresent(HolderLookup.Provider r) {
        return this.getHolder(r) != null;
    }

    public boolean isPresent(LevelReader level) {
        return this.getHolder(level) != null;
    }

    public void ifPresent(HolderLookup.Provider r, Consumer<T> consumer) {
        Holder<T> h = this.getHolder(r);
        if (h != null) {
            consumer.accept(h.value());
        }
    }

    public Optional<Holder<T>> asOptionalHolder(HolderLookup.Provider r) {
        return Optional.ofNullable(this.getHolder(r));
    }

    public Optional<T> asOptional(HolderLookup.Provider r) {
        return Optional.ofNullable(this.get(r));
    }

    @Override
    @Nullable
    public T get(HolderLookup.Provider r) {
        Holder h = super.getHolder(r);
        return (T)(h != null ? h.value() : null);
    }

    @Override
    @Nullable
    public T get(Level level) {
        return super.get(level);
    }

    @Override
    @Nullable
    public T get(Entity entity) {
        return super.get(entity);
    }

    @Override
    public boolean is(T object, HolderLookup.Provider r) {
        Holder<T> holder = this.getHolder(r);
        if (holder == null) {
            return false;
        }
        return holder.value() == object;
    }

    @Override
    public boolean is(TagKey<T> tag, HolderLookup.Provider r) {
        Holder<T> holder = this.getHolder(r);
        if (holder == null) {
            return false;
        }
        return holder.is(tag);
    }

    @Override
    @Nullable
    public Holder<T> getHolder(HolderLookup.Provider r) {
        return super.getHolder(r);
    }

    @Override
    @Nullable
    public Holder<T> getHolder(Level level) {
        return super.getHolder(level);
    }

    @Override
    @Nullable
    public Holder<T> getHolder(Entity entity) {
        return super.getHolder(entity);
    }

    @Override
    @Nullable
    public Holder<T> lookup(HolderGetter<T> lookup) {
        try {
            return super.lookup(lookup);
        }
        catch (Exception e) {
            return null;
        }
    }
}

