/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.server.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.affix.IAffixBase;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.rank.Rank;

public class ChampionSelectorOptions {
    public static void setup() {
        EntitySelectorOptions.register((String)"champions", ChampionSelectorOptions::championsArgument, entitySelectorParser -> true, (Component)Component.translatable((String)"argument.entity.options.champions.description"));
    }

    private static void championsArgument(EntitySelectorParser parser) throws CommandSyntaxException {
        StringReader reader = parser.getReader();
        boolean invert = parser.shouldInvertValue();
        CompoundTag compoundtag = new TagParser(reader).readStruct();
        HashSet<String> affixes = new HashSet<String>();
        MinMaxBounds.Ints matches = MinMaxBounds.Ints.atLeast((int)1);
        MinMaxBounds.Ints count = MinMaxBounds.Ints.ANY;
        if (compoundtag.contains("affixes", 9)) {
            ListTag listTag = compoundtag.getList("affixes", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                affixes.add(listTag.getString(i));
            }
        } else if (compoundtag.contains("affixes", 10)) {
            CompoundTag tag = compoundtag.getCompound("affixes");
            ListTag listTag = tag.getList("values", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                affixes.add(listTag.getString(i));
            }
            count = ChampionSelectorOptions.fromTag(tag, "count", count);
            matches = ChampionSelectorOptions.fromTag(tag, "matches", matches);
        }
        MinMaxBounds.Ints tier = ChampionSelectorOptions.fromTag(compoundtag, "tier", MinMaxBounds.Ints.ANY);
        MinMaxBounds.Ints finalCount = count;
        MinMaxBounds.Ints finalMatches = matches;
        parser.addPredicate(entity -> {
            boolean flag = ChampionSelectorOptions.matches(entity, affixes, tier, finalCount, finalMatches);
            return invert != flag;
        });
    }

    private static MinMaxBounds.Ints fromTag(CompoundTag origin, String key, MinMaxBounds.Ints defaultValue) {
        if (origin.contains(key, 3)) {
            int tier = origin.getInt(key);
            return MinMaxBounds.Ints.exactly((int)tier);
        }
        if (origin.contains(key, 10)) {
            CompoundTag tag = origin.getCompound(key);
            Integer min = null;
            Integer max = null;
            if (tag.contains("min", 3)) {
                min = tag.getInt("min");
            }
            if (tag.contains("max", 3)) {
                max = tag.getInt("max");
            }
            if (min == null && max == null) {
                return MinMaxBounds.Ints.ANY;
            }
            if (min != null && max == null) {
                return MinMaxBounds.Ints.atLeast((int)min);
            }
            if (min == null) {
                return MinMaxBounds.Ints.atMost((int)max);
            }
            return MinMaxBounds.Ints.between((int)min, (int)max);
        }
        return defaultValue;
    }

    private static boolean matches(Entity entity, Set<String> affixes, MinMaxBounds.Ints tier, MinMaxBounds.Ints count, MinMaxBounds.Ints matches) {
        return ChampionAttachment.getAttachment(entity).map(champion -> {
            IChampion.Server server = champion.getServer();
            int championTier = server.getRank().map(Rank::getTier).orElse(0);
            if (championTier <= 0 || !tier.matches(championTier)) {
                return false;
            }
            List<IAffix> championAffixes = server.getAffixes();
            if (affixes.isEmpty()) {
                return count.matches(championAffixes.size());
            }
            Set ids = championAffixes.stream().map(IAffixBase::getIdentifier).map(ResourceLocation::toString).collect(Collectors.toSet());
            int found = 0;
            for (String affix : affixes) {
                if (!ids.contains(affix)) continue;
                ++found;
            }
            return matches.matches(found) && count.matches(championAffixes.size());
        }).orElse(false);
    }
}

