/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.neoforged.bus.api.IEventBus;
import top.theillusivec4.champions.common.registry.AffixTypes;
import top.theillusivec4.champions.common.registry.ModArgumentTypes;
import top.theillusivec4.champions.common.registry.ModAttachments;
import top.theillusivec4.champions.common.registry.ModDataComponents;
import top.theillusivec4.champions.common.registry.ModEntitySubProviders;
import top.theillusivec4.champions.common.registry.ModEntityTypes;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.registry.ModLootItemConditions;
import top.theillusivec4.champions.common.registry.ModLootModifiers;
import top.theillusivec4.champions.common.registry.ModMobEffects;
import top.theillusivec4.champions.common.registry.ModParticleTypes;
import top.theillusivec4.champions.common.registry.ModStats;

public class ChampionsRegistry {
    private static final List<Consumer<IEventBus>> REGISTRATION_CALLBACKS = new ArrayList<Consumer<IEventBus>>();

    public static void register(IEventBus bus) {
        REGISTRATION_CALLBACKS.forEach(callback -> callback.accept(bus));
    }

    public static void addRegistrationCallback(Consumer<IEventBus> registrationCallback) {
        REGISTRATION_CALLBACKS.add(registrationCallback);
    }

    static {
        REGISTRATION_CALLBACKS.addAll(Arrays.asList(ModItems::register, ModParticleTypes::register, ModMobEffects::register, ModEntityTypes::register, ModLootModifiers::register, ModLootItemConditions::register, ModArgumentTypes::register, ModStats::register, ModAttachments::register, ModDataComponents::register, ModEntitySubProviders::register, AffixTypes::register));
    }
}

