/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.util.Utils;

public record SPacketSyncAffixData(int entityId, String affixId, CompoundTag data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SPacketSyncAffixData> TYPE = new CustomPacketPayload.Type(Utils.getLocation("main"));
    public static final StreamCodec<FriendlyByteBuf, SPacketSyncAffixData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SPacketSyncAffixData::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SPacketSyncAffixData::affixId, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SPacketSyncAffixData::data, SPacketSyncAffixData::new);

    public static void handle(SPacketSyncAffixData data, IPayloadContext cxt) {
        cxt.enqueueWork(() -> {
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null) {
                Entity entity = world.getEntity(data.entityId);
                ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    clientChampion.getAffix(data.affixId).ifPresent(affix -> affix.readSyncTag((IChampion)champion, data.data));
                });
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

