/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.util.FakePlayer;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.config.ConfigEnums;
import top.theillusivec4.champions.common.config.ConfigLoot;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModLootTables;

public class ChampionLootModifier
extends LootModifier {
    public static final MapCodec<ChampionLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> ChampionLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ChampionLootModifier::new));
    private static final ThreadLocal<Boolean> IS_PROCESSING = ThreadLocal.withInitial(() -> false);

    public ChampionLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (IS_PROCESSING.get().booleanValue()) {
            return generatedLoot;
        }
        IS_PROCESSING.set(true);
        try {
            Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
            if (entity == null) {
                ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
                return objectArrayList;
            }
            DamageSource damageSource = (DamageSource)context.getParamOrNull(LootContextParams.DAMAGE_SOURCE);
            if (damageSource == null) {
                ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
                return objectArrayList;
            }
            if (!entity.level().getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT) || !ChampionsConfig.fakeLoot && damageSource.getDirectEntity() instanceof FakePlayer) {
                ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
                return objectArrayList;
            }
            ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                List<ItemStack> loot;
                IChampion.Server serverChampion = champion.getServer();
                ServerLevel serverWorld = (ServerLevel)entity.level();
                if (ChampionsConfig.lootSource != ConfigEnums.LootSource.CONFIG) {
                    LivingEntity livingEntity;
                    LivingEntity attackingEntity;
                    LootTable lootTable = serverWorld.getServer().reloadableRegistries().getLootTable(ModLootTables.CHAMPION_LOOT);
                    LootParams.Builder lootParams$builder = new LootParams.Builder(serverWorld).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
                    if (entity instanceof LivingEntity && (attackingEntity = (livingEntity = (LivingEntity)entity).getKillCredit()) instanceof Player) {
                        Player player = (Player)attackingEntity;
                        lootParams$builder = lootParams$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withLuck(player.getLuck());
                    }
                    LootParams lootParams = lootParams$builder.create(LootContextParamSets.ENTITY);
                    lootTable.getRandomItems(lootParams, arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0));
                }
                if (ChampionsConfig.lootSource != ConfigEnums.LootSource.LOOT_TABLE && !(loot = ConfigLoot.getLootDrops(serverChampion.getRank().map(Rank::getTier).orElse(0))).isEmpty()) {
                    generatedLoot.addAll(loot);
                }
            });
            ObjectArrayList<ItemStack> objectArrayList = generatedLoot;
            return objectArrayList;
        }
        finally {
            IS_PROCESSING.set(false);
        }
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

