/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.affix.IAffixBase;

public record AffixesPredicate(Set<ResourceLocation> values, MinMaxBounds.Ints matches, MinMaxBounds.Ints count) {
    public static final Codec<AffixesPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NeoForgeExtraCodecs.setOf((Codec)ResourceLocation.CODEC).fieldOf("values").forGetter(AffixesPredicate::values), (App)MinMaxBounds.Ints.CODEC.fieldOf("matches").forGetter(AffixesPredicate::matches), (App)MinMaxBounds.Ints.CODEC.fieldOf("count").forGetter(AffixesPredicate::count)).apply((Applicative)instance, AffixesPredicate::new));

    public boolean matches(List<IAffix> input) {
        if (this.values.isEmpty()) {
            return this.count.matches(input.size());
        }
        Set affixes = input.stream().map(IAffixBase::getIdentifier).collect(Collectors.toSet());
        int found = (int)this.values.stream().filter(affixes::contains).count();
        return this.matches.matches(found) && this.count.matches(input.size());
    }
}

