/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import top.theillusivec4.champions.common.entity.BaseBulletEntity;
import top.theillusivec4.champions.common.registry.ModDamageTypes;
import top.theillusivec4.champions.common.registry.ModEntityTypes;

public class EnkindlingBulletEntity
extends BaseBulletEntity {
    public EnkindlingBulletEntity(Level level, LivingEntity livingEntity, @Nonnull Entity entity, Direction.Axis axis) {
        super((EntityType<? extends Projectile>)((EntityType)ModEntityTypes.ENKINDLING_BULLET.get()), level, livingEntity, entity, axis);
    }

    public EnkindlingBulletEntity(EntityType<? extends EnkindlingBulletEntity> enkindlingBulletEntityEntityType, Level level) {
        super(enkindlingBulletEntityEntityType, level);
    }

    @Override
    protected void bulletEffect(LivingEntity target) {
        if (this.getOwner() != null) {
            target.hurt(ModDamageTypes.of(ModDamageTypes.ENKINDLING_BULLET, (Entity)this, this.getOwner()), 1.0f);
        } else {
            target.hurt(ModDamageTypes.of(ModDamageTypes.ENKINDLING_BULLET, (Entity)this), 1.0f);
        }
        target.setRemainingFireTicks(160);
    }

    @Override
    protected ParticleOptions getParticle() {
        return ParticleTypes.FLAME;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

