/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.AbstractBasicAffix;
import top.theillusivec4.champions.common.affix.core.AffixData;
import top.theillusivec4.champions.common.affix.core.GoalCombatAffix;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.registry.ModEntityTypes;

public class InfestedAffix
extends GoalCombatAffix {
    private static void spawnParasites(LivingEntity livingEntity, int amount, @Nullable LivingEntity target, ServerLevel world) {
        boolean isEnder = livingEntity.getType().is(ModEntityTypes.Tags.IS_ENDER);
        EntityType<?> type = isEnder ? ChampionsConfig.infestedEnderParasite : ChampionsConfig.infestedParasite;
        ArrayList<Monster> children = new ArrayList<Monster>();
        for (int i = 0; i < amount; ++i) {
            Entity entity = type.create(world, null, livingEntity.blockPosition(), MobSpawnType.MOB_SUMMONED, false, false);
            if (!(entity instanceof Monster)) continue;
            Monster monster = (Monster)entity;
            children.add(monster);
        }
        if (!EventHooks.onMobSplit((Mob)((Mob)livingEntity), children).isCanceled()) {
            children.forEach(child -> {
                world.addFreshEntity((Entity)child);
                child.spawnAnim();
                child.setLastHurtByMob(target);
                child.setTarget(target);
            });
        }
    }

    @Override
    public AffixSetting createDefaultSetting() {
        return AffixSetting.builder().withDefault().setCategory(AffixCategory.OFFENSE).build();
    }

    @Override
    public void onInitialSpawn(IChampion champion) {
        AffixData.IntegerData buffer = AffixData.getData(champion, this.toString(), AffixData.IntegerData.class);
        buffer.num = Math.min(ChampionsConfig.infestedTotal, Math.max(1, (int)((double)champion.getLivingEntity().getMaxHealth() * ChampionsConfig.infestedPerHealth)));
        buffer.saveData();
    }

    @Override
    public float onHeal(IChampion champion, float amount, float newAmount) {
        if (newAmount > 0.0f && champion.getLivingEntity().getRandom().nextFloat() < 0.5f) {
            AffixData.IntegerData buffer = AffixData.getData(champion, this.toString(), AffixData.IntegerData.class);
            buffer.num = Math.min(ChampionsConfig.infestedTotal, buffer.num + 2);
            buffer.saveData();
            return Math.max(0.0f, newAmount - 1.0f);
        }
        return newAmount;
    }

    @Override
    public boolean onDeath(IChampion champion, DamageSource source) {
        Level world;
        AffixData.IntegerData buffer = AffixData.getData(champion, this.toString(), AffixData.IntegerData.class);
        LivingEntity target = null;
        if (source.getDirectEntity() instanceof LivingEntity) {
            target = (LivingEntity)source.getDirectEntity();
        }
        if ((world = champion.getLivingEntity().level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            InfestedAffix.spawnParasites(champion.getLivingEntity(), buffer.num, target, serverLevel);
        }
        return true;
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new SpawnParasiteGoal((Mob)champion.getLivingEntity())));
    }

    @Override
    public boolean canApply(IChampion champion) {
        EntityType type = champion.getLivingEntity().getType();
        return type != ChampionsConfig.infestedParasite && type != ChampionsConfig.infestedEnderParasite && super.canApply(champion);
    }

    private class SpawnParasiteGoal
    extends Goal {
        private final Mob mobEntity;
        private int attackTime;

        public SpawnParasiteGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public void start() {
            this.attackTime = ChampionsConfig.infestedInterval * 20;
        }

        public void tick() {
            --this.attackTime;
            if (this.attackTime <= 0) {
                ChampionAttachment.getAttachment((Entity)this.mobEntity).ifPresent(champion -> {
                    Level patt0$temp;
                    AffixData.IntegerData buffer = AffixData.getData(champion, InfestedAffix.this.toString(), AffixData.IntegerData.class);
                    if (buffer.num > 0 && (patt0$temp = this.mobEntity.level()) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)patt0$temp;
                        this.attackTime = ChampionsConfig.infestedInterval * 20 + this.mobEntity.getRandom().nextInt(5) * 10;
                        int amount = ChampionsConfig.infestedAmount;
                        InfestedAffix.spawnParasites((LivingEntity)this.mobEntity, amount, this.mobEntity.getTarget(), serverLevel);
                        buffer.num = Math.max(0, buffer.num - amount);
                        buffer.saveData();
                    }
                });
            }
        }

        public boolean canUse() {
            return AbstractBasicAffix.canTarget((LivingEntity)this.mobEntity, this.mobEntity.getTarget(), true);
        }
    }
}

