/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixCategory;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.AbstractBasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalCombatAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class DesecratingAffix
extends GoalCombatAffix {
    @Override
    public boolean onAttacked(IChampion champion, DamageSource source, float amount) {
        return !(source.getEntity() instanceof AreaEffectCloud) || source.getDirectEntity() != champion.getLivingEntity();
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new DesecrateGoal((Mob)champion.getLivingEntity())));
    }

    @Override
    public AffixSetting createDefaultSetting() {
        return AffixSetting.builder().withDefault().setCategory(AffixCategory.OFFENSE).build();
    }

    public static class DesecrateGoal
    extends Goal {
        private final Mob mobEntity;
        private int attackTime;

        public DesecrateGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public void start() {
            this.attackTime = ChampionsConfig.desecratingCloudInterval * 20;
        }

        public void tick() {
            LivingEntity target = this.mobEntity.getTarget();
            --this.attackTime;
            if (this.attackTime <= 0 && target != null) {
                this.attackTime = ChampionsConfig.desecratingCloudInterval * 20 + this.mobEntity.getRandom().nextInt(5) * 10;
                AreaEffectCloud cloud = new AreaEffectCloud(target.level(), target.position().x, target.position().y, target.position().z);
                cloud.setOwner((LivingEntity)this.mobEntity);
                cloud.setRadius((float)ChampionsConfig.desecratingCloudRadius);
                cloud.setDuration(ChampionsConfig.desecratingCloudDuration * 20);
                cloud.setRadiusOnUse(-0.5f);
                cloud.setWaitTime(ChampionsConfig.desecratingCloudActivationTime * 20);
                cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
                cloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
                target.level().addFreshEntity((Entity)cloud);
            }
        }

        public boolean canUse() {
            return AbstractBasicAffix.canTarget((LivingEntity)this.mobEntity, this.mobEntity.getTarget(), true);
        }
    }
}

