/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.util;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class MouseHelper {
    public static Optional<LivingEntity> getMouseOverChampion(Minecraft mc, float partialTicks) {
        Entity entity = mc.getCameraEntity();
        if (entity instanceof LivingEntity && mc.level != null) {
            Entity entity1;
            Optional<IChampion> champion;
            mc.getProfiler().push("mouse_champion");
            double d0 = ClientChampionsConfig.hudRange;
            HitResult rayTraceResult = entity.pick(d0, partialTicks, false);
            Vec3 vec3d = entity.getEyePosition(partialTicks);
            double d1 = rayTraceResult.getLocation().distanceToSqr(vec3d);
            Vec3 vec3d1 = entity.getViewVector(1.0f);
            Vec3 vec3d2 = vec3d.add(vec3d1.x * d0, vec3d1.y * d0, vec3d1.z * d0);
            AABB axisalignedbb = entity.getBoundingBox().expandTowards(vec3d1.scale(d0)).inflate(1.0, 1.0, 1.0);
            EntityHitResult entityraytraceresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)vec3d, (Vec3)vec3d2, (AABB)axisalignedbb, e -> !e.isSpectator() && e.isPickable(), (double)d1);
            if (entityraytraceresult != null && (champion = ChampionAttachment.getAttachment(entity1 = entityraytraceresult.getEntity())).isPresent() && ChampionHelper.isValidChampion(champion.get().getClient())) {
                return champion.map(IChampion::getLivingEntity);
            }
            mc.getProfiler().pop();
        }
        return Optional.empty();
    }
}

