/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.api.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.data.ModifierSetting;

public class AttributesModifierDataLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, ModifierSetting>> {
    private static final String FOLDER = "modifier_setting";
    private final Map<ResourceLocation, ModifierSetting> loadedData = new HashMap<ResourceLocation, ModifierSetting>();

    public static String getFolder() {
        return FOLDER;
    }

    protected Map<ResourceLocation, ModifierSetting> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.listResources(resourceManager, profilerFiller);
    }

    protected void apply(Map<ResourceLocation, ModifierSetting> attributeModifierMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        attributeModifierMap.putAll(this.loadedData);
    }

    public Map<ResourceLocation, ModifierSetting> listResources(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        pProfiler.startTick();
        for (Map.Entry resource : pResourceManager.listResources(FOLDER, p -> p.getPath().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)resource.getValue()).openAsReader();
                try {
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    ModifierSetting.MAP_CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(error -> Champions.LOGGER.debug("Failed to parse Attributes Modifier setting {}", error)).ifPresent(itemValues -> this.loadedData.put((ResourceLocation)resource.getKey(), (ModifierSetting)itemValues));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Champions.LOGGER.error("Failed to load custom data pack: {}", resource.getKey(), (Object)e);
            }
        }
        pProfiler.endTick();
        return this.loadedData;
    }

    public void cache(Map<ResourceLocation, ModifierSetting> attributeModifierMap) {
        this.loadedData.clear();
        this.loadedData.putAll(attributeModifierMap);
    }

    public Map<ResourceLocation, ModifierSetting> getLoadedData() {
        return this.loadedData;
    }
}

