/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.api;

import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryBuilder;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.affix.IAffix;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.registry.AffixTypes;
import top.theillusivec4.champions.common.util.Utils;

public class AffixRegistry {
    public static final ResourceKey<Registry<IAffix>> AFFIX_REGISTRY_KEY = AffixRegistry.createKey("affix");
    public static final Registry<IAffix> AFFIX_REGISTRY = new RegistryBuilder(AFFIX_REGISTRY_KEY).sync(true).maxId(2048).defaultKey(Keys.ADAPTABLE).onAdd((registry, id, resourceKey, affix) -> {
        BasicAffix basic;
        if (affix instanceof BasicAffix && (basic = (BasicAffix)affix).getSetting().equals(AffixSetting.empty())) {
            basic.applyDefaultSettingWithId();
            basic.tryRegisterEvents();
            Champions.API.addCategory(basic.getCategory(), basic);
        }
        Champions.LOGGER.info("Affix added to registry: {}", (Object)resourceKey);
    }).create();

    public static ResourceKey<IAffix> create(String path) {
        return ResourceKey.create(Keys.AFFIX_TYPE, (ResourceLocation)Utils.getLocation(path));
    }

    private static ResourceKey<Registry<IAffix>> createKey(String path) {
        return ResourceKey.createRegistryKey((ResourceLocation)Utils.getLocation(path));
    }

    public static class Keys {
        public static final ResourceKey<Registry<IAffix>> AFFIX_TYPE = AffixRegistry.createKey("affix_type");
        public static final ResourceKey<IAffix> ADAPTABLE = AffixRegistry.create("adaptable");
        public static final ResourceKey<IAffix> ARCTIC = AffixRegistry.create("arctic");
        public static final ResourceKey<IAffix> DAMPENING = AffixRegistry.create("dampening");
        public static final ResourceKey<IAffix> ENKINDLING = AffixRegistry.create("enkindling");
        public static final ResourceKey<IAffix> DESECRATING = AffixRegistry.create("desecrating");
        public static final ResourceKey<IAffix> HASTY = AffixRegistry.create("hasty");
        public static final ResourceKey<IAffix> INFESTED = AffixRegistry.create("infested");
        public static final ResourceKey<IAffix> KNOCKING = AffixRegistry.create("knocking");
        public static final ResourceKey<IAffix> LIVELY = AffixRegistry.create("lively");
        public static final ResourceKey<IAffix> MAGNETIC = AffixRegistry.create("magnetic");
        public static final ResourceKey<IAffix> MOLTEN = AffixRegistry.create("molten");
        public static final ResourceKey<IAffix> PARALYZING = AffixRegistry.create("paralyzing");
        public static final ResourceKey<IAffix> PLAGUED = AffixRegistry.create("plagued");
        public static final ResourceKey<IAffix> REFLECTIVE = AffixRegistry.create("reflective");
        public static final ResourceKey<IAffix> SHIELDING = AffixRegistry.create("shielding");
        public static final ResourceKey<IAffix> WOUNDING = AffixRegistry.create("wounding");

        public static void bootstrap(BootstrapContext<IAffix> context) {
            context.register(ADAPTABLE, (Object)((IAffix)AffixTypes.ADAPTABLE.get()));
            context.register(ARCTIC, (Object)((IAffix)AffixTypes.ARCTIC.get()));
            context.register(DAMPENING, (Object)((IAffix)AffixTypes.DAMPENING.get()));
            context.register(DESECRATING, (Object)((IAffix)AffixTypes.DESECRATING.get()));
            context.register(ENKINDLING, (Object)((IAffix)AffixTypes.ENKINDLING.get()));
            context.register(HASTY, (Object)((IAffix)AffixTypes.HASTY.get()));
            context.register(INFESTED, (Object)((IAffix)AffixTypes.INFESTED.get()));
            context.register(KNOCKING, (Object)((IAffix)AffixTypes.KNOCKING.get()));
            context.register(LIVELY, (Object)((IAffix)AffixTypes.LIVELY.get()));
            context.register(MAGNETIC, (Object)((IAffix)AffixTypes.MAGNETIC.get()));
            context.register(MOLTEN, (Object)((IAffix)AffixTypes.MOLTEN.get()));
            context.register(PARALYZING, (Object)((IAffix)AffixTypes.PARALYZING.get()));
            context.register(PLAGUED, (Object)((IAffix)AffixTypes.PLAGUED.get()));
            context.register(REFLECTIVE, (Object)((IAffix)AffixTypes.REFLECTIVE.get()));
            context.register(SHIELDING, (Object)((IAffix)AffixTypes.SHIELDING.get()));
            context.register(WOUNDING, (Object)((IAffix)AffixTypes.WOUNDING.get()));
        }
    }
}

