/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions;

import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.champions.api.ChampionsApiImpl;
import top.theillusivec4.champions.api.IChampionsApi;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.event.ModEventHandler;
import top.theillusivec4.champions.common.integration.gateways_to_eternity.GatewaysToEternityCompat;
import top.theillusivec4.champions.common.integration.kubejs.events.NeoForgeJsEventHandler;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.util.Utils;

@Mod(value="champions")
public class Champions {
    public static final String MODID = "champions";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IChampionsApi API = ChampionsApiImpl.getInstance();
    private static Champions INSTANCE;
    public final ModContainer modContainer;

    public Champions(IEventBus modEventBus, ModContainer modContainer) {
        this.modContainer = modContainer;
        INSTANCE = this;
        modEventBus.register((Object)new ModEventHandler());
        ChampionsRegistry.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChampionsConfig.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.SERVER_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientChampionsConfig.CLIENT_SPEC);
        if (Utils.isGameStagesLoaded()) {
            modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.STAGE_SPEC, "champions-gamestages.toml");
        }
        if (Utils.isGatewaysLoaded()) {
            NeoForge.EVENT_BUS.register((Object)new GatewaysToEternityCompat());
        }
        if (Utils.isKubejsLoaded()) {
            NeoForge.EVENT_BUS.register((Object)new NeoForgeJsEventHandler());
        }
    }

    public static Champions getInstance() {
        return INSTANCE;
    }
}

