/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.config.v3.json.JsonConfigFileUtil;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class ItemBlacklistManager {
    public static final ItemBlacklistManager INSTANCE = new ItemBlacklistManager();
    private DimensionBlacklist defaultBlacklist = DimensionBlacklist.create(false);
    private Map<ResourceKey<Level>, DimensionBlacklist> dimensionBlacklists = Maps.newIdentityHashMap();

    private ItemBlacklistManager() {
    }

    public boolean isItemAllowed(ResourceKey<Level> dimension, Item item) {
        DimensionBlacklist blacklist = this.dimensionBlacklists.getOrDefault(dimension, this.defaultBlacklist);
        if (blacklist.inverted()) {
            return blacklist.items().contains(item);
        }
        return !blacklist.items().contains(item);
    }

    public void loadAll(String directory) {
        this.defaultBlacklist = DimensionBlacklist.create(false);
        this.dimensionBlacklists = Maps.newIdentityHashMap();
        JsonConfigFileUtil.getAllAndLoad((String)directory, file -> {}, this::deserializeDataEntry, () -> {});
    }

    private void deserializeDataEntry(FileReader reader) {
        DimensionBlacklist blacklist;
        String[] items;
        ResourceKey dimension;
        JsonElement jsonElement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        JsonObject jsonObject = GsonHelper.convertToJsonObject((JsonElement)jsonElement, (String)"pick ups config");
        boolean inverted = jsonObject.has("inverted") ? GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"inverted") : false;
        if (jsonObject.has("dimension")) {
            ResourceLocation resourceLocation = ResourceLocationHelper.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"dimension"));
            dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)resourceLocation);
        } else {
            dimension = null;
        }
        if (jsonObject.has("items")) {
            JsonArray jsonArray = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"items");
            items = (String[])JsonConfigFileUtil.GSON.fromJson((JsonElement)jsonArray, String[].class);
        } else {
            items = new String[]{};
        }
        if (dimension != null) {
            blacklist = this.dimensionBlacklists.computeIfAbsent((ResourceKey<Level>)dimension, dimension1 -> DimensionBlacklist.create(inverted));
            if (inverted != blacklist.inverted()) {
                throw new IllegalStateException("Found multiple configs for dimension %s where one is inverted and the other one is not, this is not allowed!".formatted(dimension));
            }
        } else {
            if (inverted != this.defaultBlacklist.inverted()) {
                this.defaultBlacklist = DimensionBlacklist.create(inverted);
            }
            blacklist = this.defaultBlacklist;
        }
        blacklist.items().addAll((Collection<Item>)ConfigDataSet.from((ResourceKey)Registries.ITEM, Arrays.asList(items), (Class[])new Class[0]));
    }

    private record DimensionBlacklist(Set<Item> items, boolean inverted) {
        public static DimensionBlacklist create(boolean inverted) {
            return new DimensionBlacklist(Sets.newIdentityHashSet(), inverted);
        }
    }
}

