/*
 * Decompiled with CFR 0.152.
 */
package waves.common.entities;

import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import waves.common.entities.Wave;
import waves.util.registry.RegistryHolder;

public class WaveEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"waves");
    public static final Id<Wave> WAVES = WaveEntities.register("waves", EntityType.Builder.of(Wave::new, (MobCategory)MobCategory.MISC).sized(0.2f, 0.2f).noSave().fireImmune().canSpawnFarFromPlayer().setTrackingRange(32).clientTrackingRange(32).setUpdateInterval(1).updateInterval(1));

    public static <E extends Entity> Id<E> register(String name, EntityType.Builder<E> builder) {
        return WaveEntities.register(name, builder, true);
    }

    public static <E extends Entity> Id<E> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return new Id(ENTITIES.register(id, () -> {
            if (!serialize) {
                builder.noSave();
            }
            return builder.build("waves:" + id);
        }));
    }

    public record Id<T extends Entity>(DeferredHolder<EntityType<?>, EntityType<T>> holder) implements RegistryHolder<EntityType<?>, EntityType<T>>
    {
    }
}

