/*
 * Decompiled with CFR 0.152.
 */
package waves;

import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import waves.Waves;
import waves.config.Config;
import waves.network.PresencePacket;
import waves.util.WaveDataManager;
import waves.util.WaveHelpers;

public class EventHandler {
    public static volatile boolean firstTick = true;

    public static void init() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(EventHandler::onServerStarted);
        bus.addListener(EventHandler::onServerStopped);
        bus.addListener(EventHandler::onPlayerLogin);
        bus.addListener(EventHandler::handleWaves);
        bus.addListener(EventHandler::tickWaveEntities);
        bus.addListener(EventHandler::onBlockBreak);
        bus.addListener(EventHandler::onBlockPlaced);
    }

    public static void onServerStarted(ServerStartedEvent event) {
        WaveDataManager.WAVE_DATA.initConfigs();
        event.getServer().getAllLevels().forEach(level -> {
            WaveHelpers.BIOME_CACHE.clear();
            WaveHelpers.SHORE_CACHE.clear();
            WaveHelpers.NEAREST_SHORE_CACHE.clear();
            level.players().stream().forEach(player -> WaveHelpers.updateCaches((Level)level, (Player)player));
        });
    }

    public static void onServerStopped(ServerStoppedEvent event) {
        firstTick = true;
        WaveDataManager.WAVE_DATA.clearData();
        event.getServer().getAllLevels().forEach(level -> {
            WaveHelpers.BIOME_CACHE.clear();
            WaveHelpers.SHORE_CACHE.clear();
            WaveHelpers.NEAREST_SHORE_CACHE.clear();
        });
    }

    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PresencePacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            WaveHelpers.setIsPresent(true);
            if (((Boolean)Config.COMMON.debug.get()).booleanValue()) {
                Waves.LOGGER.info("Sending PresencePacket to player: {}", (Object)player2.getName().getString());
            }
            WaveHelpers.updateCaches(player2.level(), (Player)player2);
        }
    }

    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!((Boolean)Config.COMMON.useCaches.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            EventHandler.onBlockUpdated(level, event.getPos());
        }
    }

    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (!((Boolean)Config.COMMON.useCaches.get()).booleanValue()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            EventHandler.onBlockUpdated(level, event.getPos());
        }
    }

    public static void onBlockUpdated(Level level, BlockPos pos) {
        ConcurrentMap shoreCache;
        ResourceKey levelKey = level.dimension();
        ChunkPos chunk = new ChunkPos(pos);
        ConcurrentMap biomeLevelCache = (ConcurrentMap)WaveHelpers.BIOME_CACHE.get(levelKey);
        if (biomeLevelCache != null) {
            biomeLevelCache.remove(chunk);
        }
        if ((shoreCache = (ConcurrentMap)WaveHelpers.SHORE_CACHE.get(levelKey)) != null) {
            shoreCache.remove(chunk);
        }
    }

    public static void handleWaves(PlayerTickEvent.Post event) {
        if (!WaveHelpers.isClientSide()) {
            Player player = event.getEntity();
            Level level = player.level();
            if (player != null && level != null && (Integer)Config.COMMON.waveSpawnFrequency.get() > 0 && (Double)Config.COMMON.waveSpawnAmount.get() > 0.0 && !WaveDataManager.WAVE_DATA.get().isEmpty() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    long gameTime = level.getGameTime();
                    if (((Boolean)Config.COMMON.useCaches.get()).booleanValue() && (firstTick || (Integer)Config.COMMON.cacheUpdateFrequency.get() > 0 && gameTime % (long)((Integer)Config.COMMON.cacheUpdateFrequency.get()).intValue() == 0L)) {
                        WaveHelpers.wipeCaches(gameTime);
                        WaveHelpers.updateCaches(level, player);
                        firstTick = false;
                    }
                    if (gameTime % (long)((Integer)Config.COMMON.waveSpawnFrequency.get()).intValue() == 0L) {
                        WaveHelpers.spawnWaves((Level)serverLevel, (Player)serverPlayer);
                    }
                }
            }
        }
    }

    public static void tickWaveEntities(ServerTickEvent.Post event) {
        if (WaveDataManager.WAVE_DATA.get().isEmpty()) {
            WaveDataManager.WAVE_DATA.initConfigs();
        }
    }
}

