/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.oceansdelight.datagen;

import com.scouter.oceansdelight.OceansDelight;
import com.scouter.oceansdelight.items.ODItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "oceansdelight", existingFileHelper);
    }

    protected void registerModels() {
        this.singleTex(ODItems.TENTACLES);
        this.singleTex(ODItems.TENTACLE_ON_A_STICK);
        this.singleTex(ODItems.CUT_TENTACLES);
        this.singleTex(ODItems.BAKED_TENTACLE_ON_A_STICK);
        this.singleTex(ODItems.SQUID_RINGS);
        this.singleTex(ODItems.GUARDIAN);
        this.singleTex(ODItems.GUARDIAN_TAIL);
        this.singleTex(ODItems.COOKED_GUARDIAN_TAIL);
        this.singleTex(ODItems.GUARDIAN_SOUP);
        this.singleTex(ODItems.BOWL_OF_GUARDIAN_SOUP);
        this.singleTex(ODItems.ELDER_GUARDIAN_SLAB);
        this.singleTex(ODItems.ELDER_GUARDIAN_SLICE);
        this.singleTex(ODItems.COOKED_ELDER_GUARDIAN_SLICE);
        this.singleTex(ODItems.ELDER_GUARDIAN_ROLL);
        this.singleTex(ODItems.CABBAGE_WRAPPED_ELDER_GUARDIAN);
        this.singleTex(ODItems.FUGU_SLICE);
        this.singleTex(ODItems.FUGU_ROLL);
        this.singleTex(ODItems.CABBAGE_WRAPPED_ELDER_GUARDIAN);
        this.singleTex(ODItems.BRAISED_SEA_PICKLE);
        this.singleTex(ODItems.STUFFED_COD);
        this.singleTex(ODItems.COOKED_STUFFED_COD);
        this.singleTex(ODItems.HONEY_FRIED_KELP);
        this.singleTex(ODItems.SEAGRASS_SALAD);
    }

    private void toBlock(DeferredBlock<Block> b) {
        this.toBlockModel(b, b.getId().getPath());
    }

    private void toBlockModel(DeferredBlock<Block> b, String model) {
        this.toBlockModel(b, OceansDelight.prefix("block/" + model));
    }

    private void toBlockModel(DeferredBlock<Block> b, ResourceLocation model) {
        this.withExistingParent(b.getId().getPath(), model);
    }

    private ItemModelBuilder singleTex(DeferredItem<Item> item) {
        return this.generated(item.getId().getPath(), OceansDelight.prefix("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }
}

