/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.option.BooleanParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class AllayMagicParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public AllayMagicParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = sprites;
        this.friction = 0.96f;
        this.gravity = -0.1f;
        this.xd = this.xd * 0.1 + xSpeed;
        this.yd = this.yd * 0.1 + ySpeed;
        this.zd = this.zd * 0.1 + zSpeed;
        this.quadSize *= 0.6f;
        this.lifetime = this.random.nextIntBetweenInclusive(20, 35);
        this.hasPhysics = false;
        this.speedUpWhenYMotionIsBlocked = true;
        Util.setRandomizedColor((Particle)this, this.random, 0.133f, 0.812f, 1.0f);
        this.setSpriteFromAge(sprites);
        this.setAlpha(Mth.clamp((float)this.random.nextFloat(), (float)0.5f, (float)1.0f));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTicks) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    protected int getLightColor(float partialTick) {
        return 240;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public record VexProvider(SpriteSet sprites) implements ParticleProvider<BooleanParticleOptions>
    {
        public Particle createParticle(BooleanParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AllayMagicParticle particle = new AllayMagicParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
            if (type.bool()) {
                Util.setRandomizedColor((Particle)particle, particle.random, 0.859f, 0.478f, 0.588f);
                return particle;
            }
            Util.setRandomizedColor((Particle)particle, particle.random, 0.635f, 0.737f, 0.835f);
            return particle;
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new AllayMagicParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

