/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticleRenderTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpellParticle.class})
public abstract class SpellParticleMixin
extends TextureSheetParticle {
    @Shadow
    private float originalAlpha;
    @Unique
    private boolean subtleEffects$isFirstFrame = true;

    public SpellParticleMixin(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        if (this.subtleEffects$isFirstFrame) {
            this.subtleEffects$isFirstFrame = false;
            if (this.subtleEffects$isCloseToPlayer() && ((Float)ModConfigs.GENERAL.potionParticleAlphaNearPlayer.get()).floatValue() < 1.0f) {
                this.setAlpha(((Float)ModConfigs.GENERAL.potionParticleAlphaNearPlayer.get()).floatValue());
            } else if ((this.alpha == 1.0f || this.alpha == 0.0f) && ((Float)ModConfigs.GENERAL.potionParticleAlpha.get()).floatValue() < 1.0f) {
                this.setAlpha(((Float)ModConfigs.GENERAL.potionParticleAlpha.get()).floatValue());
            }
        }
        super.render(consumer, camera, partialTick);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (((Float)ModConfigs.GENERAL.potionParticleAlphaNearPlayer.get()).floatValue() < 1.0f) {
            if (this.subtleEffects$isCloseToPlayer()) {
                this.alpha = ((Float)ModConfigs.GENERAL.potionParticleAlphaNearPlayer.get()).floatValue();
                return;
            }
            this.alpha = Mth.lerp((float)0.05f, (float)this.alpha, (float)this.originalAlpha);
        }
    }

    @ModifyReturnValue(method={"getRenderType"}, at={@At(value="RETURN")})
    private ParticleRenderType replaceRenderType(ParticleRenderType original) {
        if (ModConfigs.GENERAL.spellParticlesUseBlendedRenderType) {
            return ModParticleRenderTypes.getBlendedOrTransparent();
        }
        return original;
    }

    @Unique
    private boolean subtleEffects$isCloseToPlayer() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        return player != null && player.getEyePosition().distanceToSqr(this.x, this.y, this.z) <= 3.0 && minecraft.options.getCameraType().isFirstPerson();
    }
}

