/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.network;

import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.StatFrameBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ServerBoundSetStatFramePacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSetStatFramePacket> CODEC = Message.makeType((ResourceLocation)AdvFrames.res("set_stat_frame"), ServerBoundSetStatFramePacket::new);
    private final BlockPos pos;
    public final ResourceLocation statValue;
    public final ResourceLocation statType;

    public ServerBoundSetStatFramePacket(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.statValue = buf.readResourceLocation();
        this.statType = buf.readResourceLocation();
    }

    public <T> ServerBoundSetStatFramePacket(BlockPos pos, StatType<T> stat, T obj) {
        this.pos = pos;
        this.statValue = stat.getRegistry().getKey(obj);
        this.statType = BuiltInRegistries.STAT_TYPE.getKey(stat);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeResourceLocation(this.statValue);
        buf.writeResourceLocation(this.statType);
    }

    public void handle(Message.Context context) {
        BlockPos pos;
        ServerPlayer serverPlayer;
        ServerLevel level;
        BlockEntity tile;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (tile = (level = (ServerLevel)(serverPlayer = (ServerPlayer)player).level()).getBlockEntity(pos = this.pos)) instanceof StatFrameBlockTile) {
            StatFrameBlockTile te = (StatFrameBlockTile)tile;
            StatType stat = (StatType)BuiltInRegistries.STAT_TYPE.get(this.statType);
            if (stat != null) {
                te.setStat(stat, this.statValue, serverPlayer);
                te.updateStatValue();
                tile.setChanged();
                level.sendBlockUpdated(pos, tile.getBlockState(), tile.getBlockState(), 3);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

