/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.network;

import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlock;
import net.mehvahdjukaar.advframes.blocks.AdvancementFrameBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ServerBoundSetAdvancementFramePacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSetAdvancementFramePacket> CODEC = Message.makeType((ResourceLocation)AdvFrames.res("set_advancement_frame"), ServerBoundSetAdvancementFramePacket::new);
    private final BlockPos pos;
    public final ResourceLocation advancementId;

    public ServerBoundSetAdvancementFramePacket(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.advancementId = buf.readResourceLocation();
    }

    public ServerBoundSetAdvancementFramePacket(BlockPos pos, AdvancementHolder advancement) {
        this.pos = pos;
        this.advancementId = advancement.id();
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeResourceLocation(this.advancementId);
    }

    public void handle(Message.Context context) {
        BlockPos pos;
        ServerPlayer serverPlayer;
        ServerLevel level;
        BlockEntity tile;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (tile = (level = (ServerLevel)(serverPlayer = (ServerPlayer)player).level()).getBlockEntity(pos = this.pos)) instanceof AdvancementFrameBlockTile) {
            AdvancementFrameBlockTile te = (AdvancementFrameBlockTile)tile;
            AdvancementHolder advancement = level.getServer().getAdvancements().get(this.advancementId);
            if (advancement != null) {
                te.setAdvancement(advancement, serverPlayer);
                level.setBlockAndUpdate(pos, (BlockState)te.getBlockState().setValue(AdvancementFrameBlock.TYPE, (Comparable)((Object)AdvancementFrameBlock.Type.get(advancement.value().display().orElse(null)))));
                tile.setChanged();
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

