/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.network;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashSet;
import java.util.Set;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.mehvahdjukaar.advframes.network.ClientBoundSendStatsPacket;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.entity.player.Player;

public class ServerBoundRequestStatsPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundRequestStatsPacket> CODEC = Message.makeType((ResourceLocation)AdvFrames.res("request_stats"), ServerBoundRequestStatsPacket::new);
    private final Set<Stat<?>> stats;

    public ServerBoundRequestStatsPacket(Set<Stat<?>> stats) {
        this.stats = new HashSet(stats);
    }

    public ServerBoundRequestStatsPacket(RegistryFriendlyByteBuf buf) {
        this.stats = (Set)buf.readCollection(HashSet::new, b -> {
            StatType statType = (StatType)b.readById(arg_0 -> ((Registry)BuiltInRegistries.STAT_TYPE).byId(arg_0));
            return ServerBoundRequestStatsPacket.readStatCap((FriendlyByteBuf)buf, statType);
        });
    }

    public static <T> Stat<T> readStatCap(FriendlyByteBuf buffer, StatType<T> statType) {
        return statType.get(buffer.readById(arg_0 -> ((Registry)statType.getRegistry()).byId(arg_0)));
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeCollection(this.stats, ServerBoundRequestStatsPacket::writeStatCap);
    }

    public static <T> void writeStatCap(FriendlyByteBuf buffer, Stat<T> stat) {
        buffer.writeById(arg_0 -> ((Registry)BuiltInRegistries.STAT_TYPE).getId(arg_0), (Object)stat.getType());
        buffer.writeById(arg_0 -> ((Registry)stat.getType().getRegistry()).getId(arg_0), stat.getValue());
    }

    public void handle(Message.Context context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerStatsCounter counter = serverPlayer.getStats();
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            Set dirty = counter.dirty;
            this.stats.retainAll(dirty);
            for (Stat<?> stat : this.stats) {
                object2IntMap.put(stat, counter.getValue(stat));
            }
            dirty.removeAll(this.stats);
            NetworkHelper.sendToClientPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientBoundSendStatsPacket((Object2IntMap<Stat<?>>)object2IntMap));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

